/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.request.request;

import crazydev.iccube.request.OlapServerCancelledRequestException;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.request.IcCubeRequestType;
import crazydev.iccube.request.status.IcCubeActiveRequestManager;
import crazydev.iccube.request.status.IcCubeRequestStateEx;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeRequest {
    private final OlapRequestId requestId;
    private final Date startDate = new Date();
    private volatile IcCubeRequestStateEx completionState;

    public IcCubeRequest(OlapRequestId requestId) {
        this.requestId = requestId;
    }

    public static void assertNotCancelled(@Nullable String message) throws OlapServerCancelledRequestException {
        if (Thread.interrupted()) {
            throw new OlapServerCancelledRequestException(message);
        }
    }

    @Nullable
    public IcCubeRequestStateEx getCompletionState() {
        return this.completionState;
    }

    public void setCompletionState(IcCubeRequestStateEx completionState) {
        this.completionState = completionState;
    }

    public abstract boolean isSchemaLifeCycle();

    public boolean isLoadMonitoring() {
        return false;
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        return null;
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return null;
    }

    public IcCubeRequestType getRequestType() {
        return IcCubeRequestType.OTHER;
    }

    @Nullable
    public Boolean getBooleanProperty(String name) {
        return null;
    }

    @Nullable
    public Long getLongProperty(String name) {
        return null;
    }

    @Nullable
    public String getProperty(String name) {
        return null;
    }

    @Nullable
    public IcCubeActiveRequestManager.GviInfo getGviInfo(String sessionUUID) {
        return null;
    }

    public OlapRequestId getRequestId() {
        return this.requestId;
    }

    public String getClientUUID() {
        return this.requestId.getClientUUID();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @Nullable
    public abstract String getSchema();

    @Nullable
    public abstract String getMdxForCancelReport();

    public boolean isMonitoredForTimeout() {
        return this.getMdxForCancelReport() != null;
    }

    public abstract boolean isUiMonitored();

    public abstract IcCubeRequestCategory getCategory();

    public abstract IcCubeRequestKind getKind();

    public abstract String getInternalTypeName();

    public abstract String getUserFriendlyTypeName();

    public String getTrackingInfo() {
        return String.format("%s  %s", this.getInternalTypeName(), this.getClientUUID());
    }

    public abstract Logger getLogger();

    public abstract String getLoggerInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcCubeRequest that = (IcCubeRequest)o;
        return this.getClientUUID().equals(that.getClientUUID());
    }

    public int hashCode() {
        return this.getClientUUID().hashCode();
    }
}

