/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.view;

import crazydev.iccube.pub.view.IOlapBuilderViewLogic;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import crazydev.iccube.pub.view.IOlapDataTableRow;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import crazydev.iccube.pub.view.IOlapViewContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class InterCompanyElimination
implements IOlapBuilderViewLogic {
    private final String costcenter = "costcenter";
    private final String intercompany = "intercompany";
    private final String nodeId = "costcenter";
    private final String parentId = "parent";
    private Map<Comparable, NodePath<Comparable>> nodes;

    @Override
    public void onInitMainTable(Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable) {
        this.doInit(cachedTables);
    }

    @Override
    public boolean onNewRow(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable, IOlapReadOnlyDataRow mainRow) {
        context.fireRow(mainRow);
        Comparable costCenter = mainRow.get("costcenter");
        Comparable interCompany = mainRow.get("intercompany");
        Comparable firstCommon = NodePath.getFirstCommonDescendant(this.nodes::get, costCenter, interCompany);
        if (firstCommon != null) {
            IOlapDataTableRow newOne = context.newRow();
            newOne.set("costcenter", firstCommon);
            newOne.set("intercompany", firstCommon);
            newOne.set("amount", (Comparable)Double.valueOf(-mainRow.getAsDouble("amount").doubleValue()));
            newOne.set("type", (Comparable)Integer.valueOf(2));
            context.fireRow(newOne);
        }
        return true;
    }

    @Override
    public void onProcessingCompleted(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables) {
    }

    private void doInit(Map<String, IOlapCachedTable> cachedTables) {
        if (cachedTables.isEmpty()) {
            return;
        }
        IOlapCachedTable accountTable = cachedTables.values().iterator().next();
        this.nodes = new HashMap<Comparable, NodePath<Comparable>>();
        accountTable.stream().forEach(row -> {
            Comparable nodeName = row.get("costcenter");
            Comparable parentName = row.get("parent");
            if (parentName != null && !parentName.equals(nodeName)) {
                NodePath parentNode = this.nodes.computeIfAbsent(parentName, NodePath::new);
                this.nodes.put(nodeName, parentNode.addChild(nodeName));
            } else {
                this.nodes.put(nodeName, new NodePath<Comparable>(nodeName));
            }
        });
    }

    public static class NodePath<T> {
        private final List<NodePath<T>> descendantsChain = new ArrayList<NodePath<T>>();
        private T elem;

        public NodePath(T elem) {
            this.elem = elem;
            this.descendantsChain.add(this);
        }

        private NodePath(T elem, NodePath<T> parent) {
            this.elem = elem;
            this.descendantsChain.addAll(parent.descendantsChain);
            this.descendantsChain.add(this);
        }

        public NodePath<T> addChild(T child) {
            NodePath<T> childNode = new NodePath<T>(child, this);
            return childNode;
        }

        public T getElem() {
            return this.elem;
        }

        @Nullable
        public static <T> T getFirstCommonDescendant(Function<T, NodePath<T>> map, T aElem, T bElem) {
            NodePath<T> b;
            if (aElem == bElem) {
                return aElem;
            }
            NodePath<T> a = aElem == null ? null : map.apply(aElem);
            NodePath<T> nodePath = b = bElem == null ? null : map.apply(bElem);
            if (a == null || b == null) {
                return null;
            }
            int maxI = Math.min(a.descendantsChain.size(), b.descendantsChain.size());
            NodePath<T> commonRoot = null;
            for (int i = 0; i < maxI; ++i) {
                NodePath<T> bNode;
                NodePath<T> aNode = a.descendantsChain.get(i);
                if (aNode != (bNode = b.descendantsChain.get(i))) continue;
                commonRoot = aNode;
            }
            return commonRoot == null ? null : (T)commonRoot.getElem();
        }
    }
}

