/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.role;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleNameFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public class OlapOnTheFlyRoleNameFactory
implements IOlapOnTheFlyRoleNameFactory {
    public static final OlapOnTheFlyRoleNameFactory INSTANCE = new OlapOnTheFlyRoleNameFactory();
    private final AtomicLong uniqueRoleUuid = new AtomicLong();
    private final Map<String, String> uniqueRoleNames = new HashMap<String, String>();

    private OlapOnTheFlyRoleNameFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, String> map = this.uniqueRoleNames;
        synchronized (map) {
            this.uniqueRoleUuid.set(0L);
            this.uniqueRoleNames.clear();
        }
    }

    public String getOrCreateUniqueRoleName(IOlapOnTheFlyRoleDescription<?> description, String fullRoleName) {
        return this.getOrCreateUniqueRoleName(null, description, fullRoleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrCreateUniqueRoleName(@Nullable String tenantName, IOlapOnTheFlyRoleDescription<?> description, String fullRoleName) {
        Map<String, String> map = this.uniqueRoleNames;
        synchronized (map) {
            Object tenantPrefix = tenantName != null ? tenantName + "-" : "";
            fullRoleName = (String)tenantPrefix + (String)fullRoleName;
            Object roleName = this.uniqueRoleNames.get(fullRoleName);
            if (roleName == null) {
                roleName = (String)tenantPrefix + description.getNameSpace() + "-" + this.uniqueRoleUuid.incrementAndGet();
                this.uniqueRoleNames.put((String)fullRoleName, (String)roleName);
            }
            if (OlapLoggers.AUTHORIZATION_ON_THE_FLY_CONTENT.isDebugEnabled()) {
                OlapLoggers.AUTHORIZATION_ON_THE_FLY_CONTENT.debug((Object)("[auth] on-the-fly-role role-name [" + (String)roleName + "] [" + (String)fullRoleName + "]"));
            }
            return roleName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String uniqueRoleName__(String fullRoleName) {
        Map<String, String> map = this.uniqueRoleNames;
        synchronized (map) {
            String res = this.uniqueRoleNames.get(fullRoleName);
            return res;
        }
    }
}

