/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.principal;

import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.tenant.OlapTenant;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapOnTheFlyPrincipal
extends OlapPrincipal {
    private static final long serialVersionUID = 4840860625910959852L;
    public static final String ROLE_NAME_FOR_DOCS_IS_ROLE_NAME = "docs-role-is-role-name";
    private final IOlapOnTheFlyRoleDescription<?> onTheFlyRoleDescription;

    public OlapOnTheFlyPrincipal(@Nullable OlapTenant tenant, String name, @Nullable Locale locale, IOlapOnTheFlyRoleDescription onTheFlyRoleDescription) {
        super(tenant, name, locale);
        this.onTheFlyRoleDescription = onTheFlyRoleDescription;
    }

    public OlapOnTheFlyPrincipal(String name, @Nullable Locale locale, IOlapOnTheFlyRoleDescription onTheFlyRoleDescription) {
        this(null, name, locale, onTheFlyRoleDescription);
    }

    @Override
    public boolean isOnTheFly() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        return "administrator".equals(this.getTemplateRoleName());
    }

    @Override
    public boolean isAnonymous() {
        return "anonymous".equals(this.getTemplateRoleName());
    }

    @Override
    public String getTemplateRoleName() {
        return this.onTheFlyRoleDescription.getTemplateRoleName();
    }

    @Override
    public String getRoleName() {
        return this.onTheFlyRoleDescription.getRoleName();
    }

    @Override
    public String getRoleNameForMdxExecutionProfile() {
        return this.onTheFlyRoleDescription.getRoleNameForMdxExecutionProfile();
    }

    @Override
    public String getRoleNameForDocs() {
        String name = this.onTheFlyRoleDescription.getRoleNameForDocs();
        if (ROLE_NAME_FOR_DOCS_IS_ROLE_NAME.equals(name)) {
            return this.getRoleName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getRoleDescription() {
        return null;
    }

    @Override
    public IOlapOnTheFlyRoleDescription<?> getOnTheFlyRoleDescription() {
        return this.onTheFlyRoleDescription;
    }
}

