/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.olap;

import crazydev.iccube.pub.olap.IOlapScalar;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public interface IOlapComparableList<T extends Comparable>
extends IOlapScalar {
    public int size();

    default public int length() {
        return this.size();
    }

    @Nullable
    public T get(int var1);

    @Nullable
    default public Double getAsDouble(int index) {
        T item = this.get(index);
        return (Double)item;
    }

    @Nullable
    default public String getAsString(int index) {
        T item = this.get(index);
        return (String)item;
    }

    @Nullable
    default public LocalDate getAsDate(int index) {
        T item = this.get(index);
        return (LocalDate)item;
    }

    @Nullable
    default public LocalDateTime getAsDateTime(int index) {
        T item = this.get(index);
        return (LocalDateTime)item;
    }

    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T value = this.get(i);
            action.accept(value);
        }
    }

    default public Stats<T> stats() {
        int size = this.size();
        int count = 0;
        Object min = null;
        Object max = null;
        Number sum = null;
        double sum2 = 0.0;
        for (int i = 0; i < size; ++i) {
            Object value = this.get(i);
            if (value == null) continue;
            ++count;
            min = min == null ? value : (value.compareTo(min) > 0 ? min : value);
            max = max == null ? value : (value.compareTo(max) < 0 ? max : value);
            if (!(value instanceof Number)) continue;
            Number number = (Number)value;
            sum = sum == null ? (Number)number : (Number)IOlapComparableList.addNumbers(sum, number);
            sum2 += number.doubleValue() * number.doubleValue();
        }
        return new Stats<Object>(min, max, count, sum, sum2);
    }

    private static Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        return a.intValue() + b.intValue();
    }

    public record Stats<T>(T min, T max, int count, Number sum, double sum2) {
    }
}

