/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub.authentication;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipalPhoto;
import crazydev.iccube.pub.tenant.OlapTenant;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeAbstractAuthenticationService
implements IOlapAuthenticationService {
    protected IcCubeAbstractAuthenticationService() {
    }

    @Override
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        OlapEngineComponent engineComponent;
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] configure Authentication Service (base)");
        try {
            IOlapPermissionsService perms = (IOlapPermissionsService)configuration.getConfigurationProperty("ic3rolePermissions");
            if (perms != null) {
                perms.configureEx(configuration);
            }
        }
        catch (RuntimeException ex) {
            throw new OlapAuthenticationServiceException(true, ex.getMessage(), ex);
        }
        OlapEngineApplicationContext olapEngineApplicationContext = (OlapEngineApplicationContext)configuration.getConfigurationProperty("olapEngineAppContext");
        if (olapEngineApplicationContext != null && (engineComponent = olapEngineApplicationContext.getOlapEngineComponent()) != null) {
            OlapLoggers.AUTHENTICATION.info((Object)"[auth] configure Authentication Service (base) : listening schema life-cycle");
            engineComponent.addStructuralSchemaLifeCycleListener(new IOlapEngineSchemaLifeCycleListener(this){
                final /* synthetic */ IcCubeAbstractAuthenticationService this$0;
                {
                    IcCubeAbstractAuthenticationService icCubeAbstractAuthenticationService = this$0;
                    Objects.requireNonNull(icCubeAbstractAuthenticationService);
                    this.this$0 = icCubeAbstractAuthenticationService;
                }

                @Override
                public void onSchemaStartedPhaseI(OlapEngineRequestContext context, OlapSchema schema, String command) {
                }

                @Override
                public void onSchemaStartedPhaseII(OlapEngineRequestContext context, OlapSchema schema, String command) {
                }

                @Override
                public void onSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
                }

                @Override
                public void onSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaLoadedOnErrorCleanup(OlapEngineRequestContext context, OlapSchema schema) {
                }

                @Override
                public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
                }

                @Override
                public void onSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
                    this.this$0.onSchemaChanged(context, schema);
                }

                @Override
                public void onSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
                    this.this$0.onSchemaChanged(context, schema);
                }
            });
        }
    }

    private void onSchemaChanged(OlapEngineRequestContext context, OlapSchema schema) {
        OlapTenant tenant = context.getUserTenant();
        String tenantName = tenant != null ? tenant.getName() : null;
        String schemaName = schema.getName();
        OlapLoggers.AUTHENTICATION.info((Object)("[auth] schema changed [" + tenantName + "] [" + schemaName + "]"));
        this.doOnSchemaChanged(tenantName, schemaName);
    }

    protected void doOnSchemaChanged(@Nullable String tenantName, String schemaName) {
    }

    @Override
    @Nullable
    public OlapPrincipalPhoto getUserPhoto(String user) {
        return null;
    }

    @Override
    public void shutdownNow() {
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] shutting down");
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] shut down");
    }

    @Override
    public boolean isSameUser(OlapPrincipal principal, String userName) {
        String principalName = principal.getName();
        if (this.isUserNameCaseSensitive()) {
            return principalName.equals(userName);
        }
        return principalName.equalsIgnoreCase(userName);
    }

    public static boolean assertPrincipal(HttpServletRequest request, OlapPrincipal principal, boolean assertPrincipalConsistency, boolean assertPrincipalConsistencyIgnoreEmptyHeader) {
        if (!assertPrincipalConsistency) {
            return true;
        }
        Map<String, String> consistency = principal.getAuthInfo();
        if (consistency != null) {
            for (Map.Entry<String, String> entry : consistency.entrySet()) {
                String principalValue;
                String key = entry.getKey();
                String headerValue = request.getHeader(key);
                if (assertPrincipalConsistencyIgnoreEmptyHeader && CdStringUtils.isNullOrBlank((String)headerValue) || Objects.equals(principalValue = entry.getValue(), headerValue)) continue;
                if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                    OlapLoggers.AUTHORIZATION.info((Object)("[auth] principal inconsistency [" + key + "][" + principalValue + "][" + headerValue + "]"));
                }
                return false;
            }
        }
        return true;
    }
}

