/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.pub;

import crazydev.iccube.pub.view.IOlapBuilderViewLogic;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapCachedTableRow;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import crazydev.iccube.pub.view.IOlapDataTableRow;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import crazydev.iccube.pub.view.IOlapViewContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;

public class CustomJavaView
implements IOlapBuilderViewLogic {
    private static final double EPSILON = 1.0E-5;
    private Map<CacheKey, List<IOlapCachedTableRow>> cachedRowsByKey;

    public static boolean equals(double a, double b) {
        return a == b || Math.abs(a - b) < 1.0E-5;
    }

    @Override
    public void onInitMainTable(Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable) {
        this.cachedRowsByKey = new HashMap<CacheKey, List<IOlapCachedTableRow>>();
        IOlapCachedTable zakTable = cachedTables.get("ZAK");
        zakTable.stream().forEach(row -> {
            if (row.get("ZLBWZLB") != null) {
                CacheKey key = CustomJavaView.getKey(row);
                List rows = this.cachedRowsByKey.computeIfAbsent(key, k -> new ArrayList());
                CustomJavaView.aggregateRow(rows, row);
            }
        });
    }

    private static void aggregateRow(List<IOlapCachedTableRow> rows, IOlapCachedTableRow newRow) {
        LocalDate newZalungDatum = newRow.getAsDate("ZLDATUM");
        for (IOlapCachedTableRow row : rows) {
            if (!newZalungDatum.equals((Object)row.getAsDate("ZLDATUM"))) continue;
            double newAmount = row.getAsDouble("ZLBWZLB") + newRow.getAsDouble("ZLBWZLB");
            row.set("ZLBWZLB", (Comparable)Double.valueOf(newAmount));
            return;
        }
        rows.add(newRow);
    }

    @Override
    public boolean onNewRow(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable, IOlapReadOnlyDataRow mainTableRow) {
        CacheKey key = CustomJavaView.getKey(mainTableRow);
        List matchingRows = this.cachedRowsByKey.getOrDefault(key, Collections.emptyList());
        if (matchingRows.size() > 1) {
            double invoiceAmount = mainTableRow.getAsDouble("LWBTR");
            double openAmount = mainTableRow.getAsDouble("LWOP");
            double cachedAmount = 0.0;
            for (IOlapCachedTableRow cachedRow : matchingRows) {
                cachedAmount += cachedRow.getAsDouble("ZLBWZLB").doubleValue();
            }
            if (!CustomJavaView.equals(invoiceAmount - openAmount, cachedAmount)) {
                context.fireRow(mainTableRow);
                for (int i = 0; i < matchingRows.size(); ++i) {
                    IOlapCachedTableRow cachedRow;
                    cachedRow = (IOlapCachedTableRow)matchingRows.get(i);
                    IOlapDataTableRow newRow = context.copyRow(mainTableRow);
                    CustomJavaView.updateRow(cachedRow, newRow);
                    newRow.set("ZLGPOS", (Comparable)Integer.valueOf(i));
                    context.fireRow(newRow);
                }
            }
        }
        return true;
    }

    private static void updateRow(IOlapCachedTableRow cachedRow, IOlapDataTableRow newRowFromMain) {
        newRowFromMain.set("LETZTEZLG", cachedRow.get("ZLDATUM"));
        newRowFromMain.set("KBL_SYSKEY", cachedRow.get("SYSKEY"));
        Double cachedZlbwzlb = cachedRow.getAsDouble("ZLBWZLB");
        newRowFromMain.set("LWBTR", (Comparable)null);
        newRowFromMain.set("LWOP", (Comparable)Double.valueOf(-cachedZlbwzlb.doubleValue()));
    }

    private static CacheKey getKey(IOlapReadOnlyDataRow mainTableRow) {
        String ic3AccountId = mainTableRow.getAsString("ic3_accountId");
        String belnr = mainTableRow.getAsString("BELNR");
        String knr = mainTableRow.getAsString("KNR");
        return new CacheKey(ic3AccountId, belnr, knr);
    }

    @Override
    public void onProcessingCompleted(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables) {
    }

    private record CacheKey(String ic3AccountId, String belnr, String knr) {
    }
}

