/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public abstract class OlapPluginUserJavaFunction {
    private final int minArgs;
    private final int maxArgs;
    private final Class[][] signatures;

    protected OlapPluginUserJavaFunction(int minArgs, int maxArgs, Class ... signature) {
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        if (maxArgs < signature.length) {
            throw new CdProgrammingException("User JAVA function [" + this.getClass().getSimpleName() + "] inconsistency [" + maxArgs + "]  - [" + signature.length + "]");
        }
        this.signatures = new Class[1][];
        this.signatures[0] = signature;
    }

    protected OlapPluginUserJavaFunction(Class[] ... signatures) {
        this.signatures = signatures;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        HashSet<Integer> lens = new HashSet<Integer>();
        for (Class[] signature : signatures) {
            if (lens.contains(signature.length)) {
                throw new CdProgrammingException("User JAVA function [" + this.getClass().getSimpleName() + "] inconsistency : all signatures must be of different lengths");
            }
            lens.add(signature.length);
            min = Math.min(min, signature.length);
            max = Math.max(max, signature.length);
        }
        this.minArgs = min;
        this.maxArgs = max;
    }

    protected OlapPluginUserJavaFunction(int minArgs, Class ... signature) {
        this(minArgs, minArgs, signature);
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public int getSignatureCount() {
        return this.signatures.length;
    }

    public int getParameterCount(int signaturePos) {
        return this.signatures[signaturePos].length;
    }

    public Class getParameterType(int signaturePos, int paramPos) {
        Class[] signature = this.signatures[signaturePos];
        return signature[Math.min(paramPos, signature.length - 1)];
    }

    protected static Class[] newArray(Class<Double> doubleClass, int maxArgs) {
        Object[] array = new Class[maxArgs];
        Arrays.fill(array, doubleClass);
        return array;
    }

    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        return null;
    }

    public Object eval(int signaturePos, Object[] args) throws OlapPluginEvaluationException {
        int nArgs = args.length;
        if (nArgs < this.minArgs || nArgs > this.maxArgs) {
            throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID);
        }
        for (int idx = 0; idx < this.minArgs; ++idx) {
            if (args[idx] != null || !this.getParameterType(signaturePos, idx).isPrimitive()) continue;
            return null;
        }
        return this.doEval(args);
    }

    protected abstract Object doEval(Object[] var1) throws OlapPluginEvaluationException;

    public String getDescription() {
        return "";
    }
}

