/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin;

import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapFilterClassLoader
extends URLClassLoader {
    @Nullable
    private final OlapLixContent classes;
    private final Set<String> loaded;

    public OlapFilterClassLoader(@Nullable OlapLixContent classes) {
        super(new URL[0]);
        this.classes = classes;
        this.loaded = new HashSet<String>();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        OlapLoggers.PLUGINS.debug((Object)("[plugins] loadClass( " + name + ", " + resolve + " )"));
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        OlapLoggers.PLUGINS.debug((Object)("[plugins] findClass( " + name + " )"));
        if (this.classes != null && (bytes = this.classes.getFilterByteCode(name)) != null) {
            OlapLoggers.PLUGINS.debug((Object)("[plugins] [x] findClass( " + name + " )"));
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, (ProtectionDomain)null);
            if (this.loaded.contains(name)) {
                throw new RuntimeException(new ObfuscatedString(new long[]{-3630234047122927780L, -8527603447682214898L, -5025692237892140428L, 1388576154529918102L}).toString() + name);
            }
            this.loaded.add(name);
            return clazz;
        }
        return super.findClass(name);
    }

    public boolean isLoaded(String name) {
        return this.loaded.contains(name);
    }
}

