/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.util;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.ICdException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.OlapResCellData;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapSelectResultPrettyPrinter {
    private final List<Integer> maxColumnSizes = new ArrayList<Integer>();
    private final List<List<OlapMember>> columns = new ArrayList<List<OlapMember>>();
    private final List<List<OlapMember>> rows = new ArrayList<List<OlapMember>>();
    private final OlapResStatementDataSet result;
    private final Map<OlapMember, OlapMemberPropertyValues> allMemberPropertyValues;
    private OlapNameContext nameContext;

    public OlapSelectResultPrettyPrinter(OlapResStatementDataSet result, Locale locale) {
        this.result = result;
        this.nameContext = OlapNameContext.DEFAULT_VALUES;
        this.allMemberPropertyValues = result.isError() ? null : ((OlapResSelectStatementDataSet)result).getAllMemberPropertyValues();
    }

    public String print() {
        StringWriter out = new StringWriter();
        this.print(new PrintWriter(out));
        return out.getBuffer().toString();
    }

    public void print(PrintWriter out) {
        OlapResAxis[] axes;
        ICdException error = this.result.getException();
        if (error != null) {
            out.println("ERROR [" + error.getMessage() + "]");
            error.printStackTrace(out);
            return;
        }
        OlapResSelectStatementDataSet myResult = (OlapResSelectStatementDataSet)this.result;
        if (myResult.getAxes().length > 2) {
            return;
        }
        OlapResCellData cells = myResult.getCells();
        if (cells.getCellCount() > 0) {
            out.println("");
            out.print("Cell Properties :");
            for (OlapCellProperty prop : cells.getRequestedProperties()) {
                out.print(" " + prop.getName());
            }
            out.println("");
        }
        if ((axes = myResult.getAxes()).length > 2) {
            throw new CdProgrammingException("Too many axes [" + axes.length + "] for pretty printing!");
        }
        if (axes.length == 0) {
            if (cells.getCellCount() > 1) {
                throw new CdProgrammingException("Boom!");
            }
            if (cells.getCellCount() == 1) {
                out.println("");
                out.println(OlapSelectResultPrettyPrinter.getFormattedValue(cells.getCell(0)));
            }
            if (cells.getCellCount() == 0) {
                out.println("");
                out.println("Empty SELECT result!");
            }
            return;
        }
        OlapResAxis onColumns = axes[0];
        OlapResAxis onRows = axes.length > 1 ? axes[1] : null;
        this.prepareOnRows(onRows);
        this.prepareOnColumns(onColumns, onRows, cells);
        out.println("");
        this.printOnColumns(out);
        this.printOnRows(null, out, onColumns, onRows, cells);
    }

    /*
     * WARNING - void declaration
     */
    private void prepareOnColumns(OlapResAxis onColumns, @Nullable OlapResAxis onRows, OlapResCellData cells) {
        for (OlapTuple olapTuple : onColumns.getTuples()) {
            int n;
            if (this.rows.isEmpty()) {
                for (n = 0; n < olapTuple.getMemberCount(); ++n) {
                    this.rows.add(new ArrayList());
                }
            }
            for (n = 0; n < olapTuple.getMemberCount(); ++n) {
                this.rows.get(n).add(olapTuple.getMember(n));
            }
        }
        int colOffset = this.columns.size();
        for (List<OlapMember> list : this.rows) {
            for (int col = 0; col < list.size(); ++col) {
                OlapMember member = list.get(col);
                int size = this.getMemberCaption(member).length();
                if (col >= this.maxColumnSizes.size() - colOffset) {
                    this.maxColumnSizes.add(0);
                }
                if (size <= this.maxColumnSizes.get(col + colOffset)) continue;
                this.maxColumnSizes.set(col + colOffset, size);
            }
        }
        if (onRows == null) {
            void var5_9;
            boolean bl = false;
            while (var5_9 < onColumns.getTupleCount()) {
                OlapResCell olapResCell = cells.getCell((int)var5_9);
                int size = OlapSelectResultPrettyPrinter.getFormattedValue(olapResCell).length();
                if (size > this.maxColumnSizes.get((int)(var5_9 + colOffset))) {
                    this.maxColumnSizes.set((int)(var5_9 + colOffset), size);
                }
                ++var5_9;
            }
        } else {
            void var5_11;
            boolean bl = false;
            while (var5_11 < onRows.getTupleCount()) {
                void var6_17;
                boolean bl2 = false;
                while (var6_17 < onColumns.getTupleCount()) {
                    OlapResCell cell = cells.getCell(new int[]{var6_17, var5_11});
                    int size = OlapSelectResultPrettyPrinter.getFormattedValue(cell).length();
                    if (size > this.maxColumnSizes.get((int)(var6_17 + colOffset))) {
                        this.maxColumnSizes.set((int)(var6_17 + colOffset), size);
                    }
                    ++var6_17;
                }
                ++var5_11;
            }
        }
    }

    private void printOnColumns(PrintWriter out) {
        int horizontalOffset = 0;
        for (int col = 0; col < this.columns.size(); ++col) {
            int msize = this.maxColumnSizes.get(col);
            horizontalOffset += msize + 3;
        }
        for (int row = 0; row < this.rows.size(); ++row) {
            StringBuilder line = new StringBuilder();
            for (int p = 0; p < horizontalOffset; ++p) {
                line.append(" ");
            }
            List<OlapMember> members = this.rows.get(row);
            for (int col = 0; col < members.size(); ++col) {
                OlapMember member = members.get(col);
                line.append(" | ");
                int len = line.length();
                line.append(this.getMemberCaption(member));
                int padding = len + this.maxColumnSizes.get(col + this.columns.size()) - line.length();
                for (int p = 0; p < padding; ++p) {
                    line.append(" ");
                }
            }
            out.println(String.valueOf(line) + " |");
        }
    }

    private void prepareOnRows(@Nullable OlapResAxis onRows) {
        if (onRows == null) {
            return;
        }
        for (OlapTuple tuple : onRows.getTuples()) {
            int idx;
            if (this.columns.isEmpty()) {
                for (idx = 0; idx < tuple.getMemberCount(); ++idx) {
                    this.columns.add(new ArrayList());
                }
            }
            for (idx = 0; idx < tuple.getMemberCount(); ++idx) {
                List<OlapMember> column = this.columns.get(idx);
                column.add(tuple.getMember(idx));
            }
        }
        for (int idx = 0; idx < this.columns.size(); ++idx) {
            List<OlapMember> column = this.columns.get(idx);
            for (OlapMember member : column) {
                int size = this.getMemberCaption(member).length() + member.getLevel().getDepth() * 2;
                if (idx >= this.maxColumnSizes.size()) {
                    this.maxColumnSizes.add(0);
                }
                if (size <= this.maxColumnSizes.get(idx)) continue;
                this.maxColumnSizes.set(idx, size);
            }
        }
    }

    private void printOnRows(OlapNameContext nameContext, PrintWriter out, OlapResAxis onColumns, @Nullable OlapResAxis onRows, OlapResCellData cells) {
        if (onRows == null) {
            StringBuilder line = new StringBuilder();
            for (int col = 0; col < onColumns.getTupleCount(); ++col) {
                line.append(" | ");
                int len = line.length();
                OlapResCell cell = cells.getCell(col);
                line.append(OlapSelectResultPrettyPrinter.getFormattedValue(cell));
                int padding = len + this.maxColumnSizes.get(col + this.columns.size()) - line.length();
                for (int p = 0; p < padding; ++p) {
                    line.append(" ");
                }
            }
            out.println(String.valueOf(line) + " |");
            return;
        }
        for (int row = 0; row < onRows.getTupleCount(); ++row) {
            int col;
            StringBuilder line = new StringBuilder();
            for (col = 0; col < this.columns.size(); ++col) {
                line.append(" | ");
                List<OlapMember> column = this.columns.get(col);
                OlapMember member = column.get(row);
                int len = line.length();
                if (row == 0) {
                    this.appendMemberCaption(line, member);
                } else if (!member.equals(column.get(row - 1))) {
                    this.appendMemberCaption(line, member);
                } else if (col > 0 && !this.columns.get(col - 1).get(row).equals(this.columns.get(col - 1).get(row - 1))) {
                    this.appendMemberCaption(line, member);
                }
                int padding = len + this.maxColumnSizes.get(col) - line.length();
                for (int p = 0; p < padding; ++p) {
                    line.append(" ");
                }
            }
            for (col = 0; col < onColumns.getTupleCount(); ++col) {
                line.append(" | ");
                int len = line.length();
                OlapResCell cell = cells.getCell(col, row);
                line.append(OlapSelectResultPrettyPrinter.getFormattedValue(cell));
                int padding = len + this.maxColumnSizes.get(col + this.columns.size()) - line.length();
                for (int p = 0; p < padding; ++p) {
                    line.append(" ");
                }
            }
            out.println(String.valueOf(line) + " |");
        }
    }

    private void appendMemberCaption(StringBuilder line, OlapMember member) {
        for (int d = 0; d < member.getLevel().getDepth(); ++d) {
            line.append("  ");
        }
        line.append(this.getMemberCaption(member));
    }

    private String getMemberCaption(OlapMember member) {
        OlapMemberPropertyValues values = this.allMemberPropertyValues.get(member);
        if (values != null) {
            return this.nameContext.getCaption(values);
        }
        return member.getName(this.nameContext);
    }

    private static String getFormattedValue(OlapResCell cell) {
        if (cell.isOnError()) {
            return "ERROR:" + cell.getException().getMessage();
        }
        if (cell.isEmpty()) {
            return cell.toString();
        }
        List<OlapCellProperty> properties = cell.getRequestedProperties();
        String fv = null;
        for (int pos = 0; pos < properties.size(); ++pos) {
            OlapCellProperty property = properties.get(pos);
            if (!property.isFormattedValue()) continue;
            OlapScalarEntity value = cell.getRequestedPropertyValues()[pos];
            if (value == null) {
                throw new CdRuntimeException("Missing FORMATTED_VALUE property value!");
            }
            fv = value.asString();
            break;
        }
        String v = null;
        for (int pos = 0; pos < properties.size(); ++pos) {
            OlapCellProperty property = properties.get(pos);
            if (!property.isValue()) continue;
            OlapScalarEntity value = cell.getRequestedPropertyValues()[pos];
            if (value == null) {
                throw new CdRuntimeException("Missing VALUE property value!");
            }
            v = value.asString();
            break;
        }
        if (v != null) {
            if (fv != null) {
                return "(v)" + v + " (fv)" + fv;
            }
            return "(v)" + v;
        }
        if (fv != null) {
            return "(fv)" + fv;
        }
        return "";
    }
}

