/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.util;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapAndTor;
import crazydev.iccube.olap.util.IOlapExistCalculator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OlapExistCalculator
implements IOlapExistCalculator {
    private List<Calculator> calculators;
    private int membersCount;

    private OlapExistCalculator(OlapMember[] members, int membersCount) {
        this.init(members, membersCount);
    }

    private OlapExistCalculator(OlapMember[] members) {
        this(members, members.length);
    }

    public static IOlapExistCalculator create(OlapTuple a, OlapTuple b) {
        if (a.getMemberCount() == 1 && b.getMemberCount() == 1) {
            OlapMember memberA = a.getMember(0);
            OlapMember memberB = b.getMember(0);
            if (memberA.getHierarchy().hasOneRelationWithBase(memberB.getHierarchy()) || memberB.getHierarchy().hasOneRelationWithBase(memberA.getHierarchy())) {
                return new AttributeBaseExists(memberA, memberB);
            }
            if (memberA.getHierarchy() == memberB.getHierarchy()) {
                return (tuple1, tuple2) -> tuple1.getMember(0).isSameBranch(tuple2.getMember(0));
            }
            return OlapExistCalculator.standardNonEmpty();
        }
        OlapMember[] members = new OlapMember[a.getMemberCount() + b.getMemberCount()];
        a.addMembersInArray(members, 0);
        b.addMembersInArray(members, a.getMemberCount());
        return new OlapExistCalculator(members);
    }

    @NotNull
    private static IOlapExistCalculator standardNonEmpty() {
        return (tuple1, tuple2) -> OlapBitmapAggregation.isNoEmpty_And(((OlapMember)tuple1).getBaseMemberBitmap4Exist(), ((OlapMember)tuple2).getBaseMemberBitmap4Exist());
    }

    /*
     * WARNING - void declaration
     */
    private void init(OlapMember[] members, int membersCount) {
        this.membersCount = membersCount;
        HashMap<Integer, IntArrayList> map = new HashMap<Integer, IntArrayList>();
        for (int i = 0; i < membersCount; ++i) {
            void var6_6;
            OlapMember member = members[i];
            IntArrayList intArrayList = (IntArrayList)map.get(member.getDimension().getDimensionalityIndex());
            if (intArrayList == null) {
                IntArrayList intArrayList2 = new IntArrayList();
                map.put(member.getDimension().getDimensionalityIndex(), intArrayList2);
            }
            var6_6.add(i);
        }
        boolean needsAutoExist = false;
        for (IntArrayList intArrayList : map.values()) {
            needsAutoExist |= intArrayList.size() > 1;
        }
        this.calculators = new ArrayList<Calculator>();
        if (needsAutoExist) {
            for (Map.Entry entry : map.entrySet()) {
                int dimensionality = (Integer)entry.getKey();
                IntArrayList posInTuple = (IntArrayList)entry.getValue();
                if (posInTuple.size() <= 1) continue;
                this.calculators.add(new Calculator(dimensionality, posInTuple));
            }
        }
    }

    @Override
    public boolean exists(OlapTuple tuple1, OlapTuple tuple2) {
        OlapMember[] members = new OlapMember[this.membersCount];
        tuple1.addMembersInArray(members, 0);
        tuple2.addMembersInArray(members, tuple1.getMemberCount());
        int size = this.calculators.size();
        for (int i = 0; i < size; ++i) {
            Calculator calculator = this.calculators.get(i);
            if (calculator.exists(members)) continue;
            return false;
        }
        return true;
    }

    private static class AttributeBaseExists
    implements IOlapExistCalculator {
        boolean isFirstBase;
        IOlapExistCalculator standard = OlapExistCalculator.standardNonEmpty();

        public AttributeBaseExists(OlapMember first, OlapMember second) {
            this.isFirstBase = first.getHierarchy().hasOneRelationWithBase(second.getHierarchy());
        }

        @Override
        public boolean exists(OlapTuple tuple1, OlapTuple tuple2) {
            OlapMember sec;
            OlapMember first = this.isFirstBase ? tuple1.getMember(0) : tuple2.getMember(0);
            OlapMember firstAttr = first.getAttributeMember((sec = this.isFirstBase ? tuple2.getMember(0) : tuple1.getMember(0)).getHierarchy());
            if (firstAttr == null) {
                return this.standard.exists(tuple1, tuple2);
            }
            return OlapMember.equal(firstAttr, sec) || firstAttr.isDescendant(sec);
        }
    }

    private static class Calculator {
        final int dimensionality;
        final IntArrayList posInTuple;

        private Calculator(int dimensionality, IntArrayList posInTuple) {
            this.dimensionality = dimensionality;
            this.posInTuple = posInTuple;
        }

        boolean exists(OlapMember[] members) {
            IBitmapAndTor andtor = OlapBitmapAggregation.createOlapBitmapAndtor();
            int size = this.posInTuple.size();
            for (int i = 0; i < size; ++i) {
                int pos = this.posInTuple.getInt(i);
                OlapMember member = members[pos];
                if (member.getDimension().getDimensionalityIndex() != this.dimensionality) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                OlapBitmap bitmap = member.getBaseMemberBitmap4Exist();
                if (bitmap == null) continue;
                andtor.addForAnd(bitmap);
            }
            return andtor.isNoEmpty();
        }
    }
}

