/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.stats.OlapIncrLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadGCStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsStatus;
import crazydev.iccube.olap.schema.stats.OlapSchemaTableStats;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaStatsHolder {
    private final Object LOCK = new Object();
    private final String schemaName;
    private final OlapSchemaFullLoadGCStats fullLoadGCStats = new OlapSchemaFullLoadGCStats();
    @Nullable
    private volatile OlapSchemaStats stats;
    @Nullable
    private volatile OlapSchemaFullLoadStats fullLoadStats;
    @Nullable
    private volatile OlapIncrLoadStats statsIncr;

    public OlapSchemaStatsHolder(String schemaName) {
        this.schemaName = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSchemaStats refreshStats(@Nullable IcCubeRequestStatusManager requests, OlapSchema schema) {
        OlapSchemaTableStats tStats = requests != null ? this.getOrCreateTableStats(requests, schema) : new OlapSchemaTableStats(new ArrayList<OlapSchemaTableStats.Info>(), new ArrayList<OlapSchemaTableStats.Info>());
        Object object = this.LOCK;
        synchronized (object) {
            this.stats = this.createStats(schema, tStats);
            if (schema.isIncrLoadActive()) {
                this.statsIncr = this.createIncrLoadStats(schema);
            }
            return this.stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapSchemaTableStats getOrCreateTableStats(IcCubeRequestStatusManager requests, OlapSchema schema) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapSchemaStats stats_ = this.stats;
            if (stats_ != null) {
                return stats_.getTableStats();
            }
        }
        OlapSchemaInformation info = schema.getInformation();
        String uuid = info.getRequestUuid();
        return requests.createTableStats(uuid);
    }

    private OlapSchemaStats createStats(OlapSchema schema, @Nullable OlapSchemaTableStats tStats) {
        return schema.createStats(tStats);
    }

    @Nullable
    private OlapIncrLoadStats createIncrLoadStats(OlapSchema schema) {
        try {
            return schema.createIncrLoadStats();
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] could not compute incr. load stats", (Throwable)ex);
            this.statsIncr = null;
            return null;
        }
    }

    public void onGCActivity(String name, long elapsedMS, long freeM, long totalM, long maxM) {
        this.fullLoadGCStats.onGCActivity(name, elapsedMS, freeM, totalM, maxM);
    }

    public void onFactsProcessingStarted() {
        this.fullLoadGCStats.onFactsProcessingStarted();
    }

    public void onMergeCompleted(OlapSchema schema) {
        OlapSchemaStats stats_ = this.stats;
        if (stats_ != null) {
            stats_.setStatus(OlapSchemaStatsStatus.OBSOLETE);
        }
    }

    public void onLoadEntityCompleted(OlapSchema schema) {
        OlapSchemaStats stats_ = this.stats;
        if (stats_ != null) {
            stats_.setStatus(OlapSchemaStatsStatus.OBSOLETE);
        }
    }

    public void onIncrLoadProcessingCompleted(Logger logger, OlapSchema schema) {
        OlapSchemaStats stats_ = this.stats;
        if (stats_ != null) {
            stats_.setStatus(OlapSchemaStatsStatus.OBSOLETE);
            if (logger.isDebugEnabled()) {
                OlapIncrLoadStats statsIncr_ = this.statsIncr;
                this.statsIncr = this.createIncrLoadStats(schema);
                OlapBuilderSchemaMain.debugLogIncrLoadDimensionStatistics(logger, schema.getName(), statsIncr_, this.statsIncr);
            } else {
                this.statsIncr = null;
            }
        }
    }

    public OlapSchemaStats getStats() {
        OlapSchemaStats stats_ = this.stats;
        if (stats_ == null) {
            stats_ = new OlapSchemaStats(this.fullLoadGCStats, this.getFullLoadStats(), null, this.schemaName, OlapSchemaStatsStatus.NOT_AVAILABLE);
        }
        return stats_;
    }

    @Nullable
    public OlapSchemaFullLoadStats getFullLoadStats() {
        return this.fullLoadStats;
    }

    public void setFullLoadStats(OlapSchemaFullLoadStats stats) {
        this.fullLoadStats = stats;
    }

    public OlapSchemaFullLoadGCStats getFullLoadGCStats() {
        return this.fullLoadGCStats;
    }
}

