/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.common.system.CdVirtualMachine;
import crazydev.common.utils.CdOperatingSystemUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsBitmapCount;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsSizeOf;
import crazydev.iccube.olap.schema.stats.OlapCategoryStats;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelBitmapStats;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import crazydev.iccube.olap.schema.stats.OlapMeasureStats;
import crazydev.iccube.olap.schema.stats.OlapSavePointStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadGCStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsStatus;
import crazydev.iccube.olap.schema.stats.OlapSchemaTableStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaTimingStats;
import crazydev.iccube.olap.schema.stats.OlapStatsFields;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.version.OlapVersion;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaStats {
    private final OlapSchemaFullLoadGCStats fullLoadGCStats;
    @Nullable
    private final OlapSchemaFullLoadStats fullLoadStats;
    @Nullable
    private final OlapSchemaTableStats tableStats;
    private final Date timestamp = new Date();
    @Nullable
    private final Date backupTimestamp;
    private final Date lastUpdateTimestamp;
    private final Date refreshTimestamp;
    private final String name;
    private final List<String> warnings;
    @Nullable
    private final OlapSchemaTimingStats timings;
    private final boolean incrLoadActive;
    private final List<String> nonIndexingDimensions;
    private final List<OlapDimensionStats> dimensions;
    @Nullable
    private final OlapCategoryStats categoryStats;
    private final List<OlapFactsStats> facts;
    private final long savePointsRamSize;
    private final long bridgeSize;
    private final long lookupTableSize;
    private final long autoExistRamSize;
    @Nullable
    private final List<OlapSavePointStats> savePoints;
    private volatile OlapSchemaStatsStatus status;

    public OlapSchemaStats(OlapSchemaFullLoadGCStats fullLoadGCStats, @Nullable OlapSchemaFullLoadStats fullLoadStats, @Nullable OlapSchemaTableStats tableStats, String name, OlapSchemaStatsStatus status) {
        this(fullLoadGCStats, fullLoadStats, tableStats, null, new Date(), new Date(), name, new ArrayList<String>(), null, false, new ArrayList<String>(), new ArrayList<OlapDimensionStats>(), null, new ArrayList<OlapFactsStats>(), 0L, 0L, 0L, null, 0L);
        this.status = status;
    }

    public OlapSchemaStats(OlapSchemaFullLoadGCStats fullLoadGCStats, @Nullable OlapSchemaFullLoadStats fullLoadStats, @Nullable OlapSchemaTableStats tableStats, @Nullable Date backupTimestamp, Date lastUpdateTimestamp, Date refreshTimestamp, String name, List<String> warnings, @Nullable OlapSchemaTimingStats timings, boolean incrLoadActive, List<String> nonIndexingDimensions, List<OlapDimensionStats> dimensions, @Nullable OlapCategoryStats categoryStats, List<OlapFactsStats> facts, long savePointsRamSize, long bridgeSize, long lookupTableSize, @Nullable List<OlapSavePointStats> savePoints, long autoExistRamSize) {
        this.fullLoadGCStats = fullLoadGCStats;
        this.fullLoadStats = fullLoadStats;
        this.tableStats = tableStats;
        this.backupTimestamp = backupTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.refreshTimestamp = refreshTimestamp;
        this.name = name;
        this.warnings = warnings;
        this.incrLoadActive = incrLoadActive;
        this.timings = timings;
        this.nonIndexingDimensions = nonIndexingDimensions;
        this.dimensions = dimensions;
        this.categoryStats = categoryStats;
        this.facts = facts;
        this.savePointsRamSize = savePointsRamSize;
        this.bridgeSize = bridgeSize;
        this.lookupTableSize = lookupTableSize;
        this.savePoints = savePoints;
        this.autoExistRamSize = autoExistRamSize;
        this.dimensions.sort(Comparator.comparing(OlapDimensionStats::getRamSize).reversed());
        this.facts.sort(Comparator.comparing(OlapFactsStats::getRamSize).reversed());
        this.status = OlapSchemaStatsStatus.UP_TO_DATE;
    }

    @Nullable
    public OlapSchemaTableStats getTableStats() {
        return this.tableStats;
    }

    public boolean isIncrLoadActive() {
        return this.incrLoadActive;
    }

    public List<OlapDimensionStats> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    public OlapDimensionStats getDimension(String name) {
        for (OlapDimensionStats dimension : this.dimensions) {
            if (!OlapCaseInsensitiveName.equals(dimension.getName(), name)) continue;
            return dimension;
        }
        return null;
    }

    @Nullable
    public OlapCategoryStats getCategoryStats() {
        return this.categoryStats;
    }

    public List<OlapFactsStats> getFacts() {
        return this.facts;
    }

    @Nullable
    public OlapFactsStats getFacts(String name) {
        for (OlapFactsStats fact : this.facts) {
            if (!OlapCaseInsensitiveName.equals(fact.getName(), name)) continue;
            return fact;
        }
        return null;
    }

    public boolean isRestoredFromConvertedBackup() {
        for (OlapFactsStats fact : this.facts) {
            if (!fact.isRestoredFromConvertedBackup()) continue;
            return true;
        }
        return false;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    @Nullable
    public OlapSchemaTimingStats getTimings() {
        return this.timings;
    }

    public String print(boolean forUI) {
        StringBuilder sb = new StringBuilder();
        if (this.status == OlapSchemaStatsStatus.NOT_AVAILABLE) {
            OlapSchemaStats.println(sb, "Schema Name : " + this.name + " [ not-available (please refresh) ]");
            return sb.toString();
        }
        if (this.status == OlapSchemaStatsStatus.OBSOLETE) {
            OlapSchemaStats.println(sb, "Schema Name         : " + this.name + " [ obsolete (please refresh) ]");
        } else {
            OlapSchemaStats.println(sb, "Schema Name         : " + this.name);
        }
        if (!this.warnings.isEmpty()) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Please review warning(s) at the end of this report.");
        }
        if (this.isRestoredFromConvertedBackup()) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "One (or more) facts index has been converted. Consider redoing your backup for faster restoration time.");
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Timestamp (stats.)  : " + OlapSchemaStats.formatTime(this.timestamp));
        OlapSchemaStats.println(sb, "");
        if (this.backupTimestamp != null) {
            OlapSchemaStats.println(sb, "Backup              : " + OlapSchemaStats.formatTime(this.backupTimestamp));
        }
        OlapSchemaStats.println(sb, "Data Update Time    : " + OlapSchemaStats.formatTime(this.lastUpdateTimestamp));
        OlapSchemaStats.println(sb, "Refresh Time        : " + OlapSchemaStats.formatTime(this.refreshTimestamp));
        if (this.timings != null) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Loading Time        : " + CdTimeUtils.formatMillis((long)this.timings.totalMS) + " ( dimensions: " + CdTimeUtils.formatMillis((long)this.timings.dimensionMS) + ", facts: " + CdTimeUtils.formatMillis((long)this.timings.factsMS) + ", m-2-m: " + CdTimeUtils.formatMillis((long)this.timings.many2manyMS) + " )");
            if (this.fullLoadStats != null) {
                OlapSchemaStats.println(sb, "Loading Conf.       : " + this.fullLoadStats.getConfiguration());
            }
        }
        if (this.incrLoadActive) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Incremental Load    : active");
        }
        if (!this.incrLoadActive && this.fullLoadStats != null) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Temporary Data (required while loading the schema)");
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "      Member Mapper : " + OlapSchemaStats.formatSize(this.fullLoadStats.getMemberMapperRamSize()));
            OlapSchemaStats.println(sb, "      Lookup Tables : " + OlapSchemaStats.formatSize(this.fullLoadStats.getLookupTableRamSize()));
            OlapSchemaStats.println(sb, "            Bridges : " + OlapSchemaStats.formatSize(this.fullLoadStats.getBridgeRamSize()));
            OlapSchemaStats.println(sb, "          Fact Meta : " + OlapSchemaStats.formatSize(this.getMaxMetaTemporarySize()) + " (" + OlapSchemaStats.formatSize(this.getSumMetaTemporarySize()) + ")");
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Estimated Total RAM : " + OlapSchemaStats.formatSize(this.getTotalRamSize()) + " [" + CdStringUtils.formatNice((long)this.getTotalRamSize()) + "] [" + this.name + "]");
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Dimension   Count   : " + OlapSchemaStats.formatCount(this.getTotalDimensionCount()));
        OlapSchemaStats.println(sb, "Hierarchy   Count   : " + OlapSchemaStats.formatCount(this.getTotalHierarchyCount()));
        OlapSchemaStats.println(sb, "Level       Count   : " + OlapSchemaStats.formatCount(this.getTotalLevelCount()));
        OlapSchemaStats.println(sb, "Member      Count   : " + OlapSchemaStats.formatCount(this.getTotalMemberCount()));
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Member Total    RAM : " + OlapSchemaStats.formatSize(this.getTotalMemberRamSize()));
        OlapSchemaStats.println(sb, "       Exist    RAM : " + OlapSchemaStats.formatSize(this.getTotalMemberExistsRamSize()) + " (not included in Member Total)");
        if (this.categoryStats != null) {
            this.categoryStats.print(sb);
        }
        if (this.incrLoadActive) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Incremental Load    : " + OlapSchemaStats.formatSize(this.getTotalSavePointsRamSize()));
        }
        if (this.getTotalBridgeRamSize() > 0L) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Bridges             : " + OlapSchemaStats.formatSize(this.getTotalBridgeRamSize()));
        }
        if (this.getTotalLookupTableRamSize() > 0L) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "Lookup Tables       : " + OlapSchemaStats.formatSize(this.getTotalLookupTableRamSize()));
        }
        boolean factsInFiles = this.isFactsInFiles();
        boolean indexInFiles = this.isIndexInFiles();
        if (indexInFiles || factsInFiles) {
            OlapSchemaStats.println(sb, "");
        }
        if (indexInFiles) {
            OlapSchemaStats.println(sb, "Index in Files      : active");
        }
        if (factsInFiles) {
            OlapSchemaStats.println(sb, "Facts in Files      : active");
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Facts         Count : " + OlapSchemaStats.formatCount(this.getTotalFactCount()));
        OlapSchemaStats.println(sb, "Partition (T) Count : " + OlapSchemaStats.formatCount(this.getTotalTablePartitionCount()));
        OlapSchemaStats.println(sb, "Partition (L) Count : " + OlapSchemaStats.formatCount(this.getTotalLevelPartitionCount()));
        OlapSchemaStats.println(sb, "Row           Count : " + OlapSchemaStats.formatCount(this.getTotalRowCount()));
        OlapSchemaStats.println(sb, "Facts Index   Count : " + this.getTotalFactsBitmapCount().formatCount());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Facts Index    RAM  : " + this.getTotalFactsBitmapsRamSize().formatRamSize());
        if (indexInFiles) {
            OlapSchemaStats.println(sb, "Facts Index  Files  : " + this.getTotalFactsBitmapsRamSize().formatFileSize());
        }
        if (!factsInFiles) {
            OlapSchemaStats.println(sb, "Facts Columns  RAM  : " + OlapSchemaStats.formatSize(this.getTotalFactsColumnsRamSize()));
        } else {
            OlapSchemaStats.println(sb, "Facts Columns Files : " + OlapSchemaStats.formatSize(this.getTotalFactsColumnsFilesSize()));
        }
        long uRows = this.getTotalUnresolvedRowCount();
        if (uRows > 0L) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "U. Row      Count   : " + OlapSchemaStats.formatCount(this.getTotalUnresolvedRowCount()));
            OlapSchemaStats.println(sb, "U. Row      RAM     : " + OlapSchemaStats.formatSize(this.getTotalUnresolvedRowRamSize()));
        }
        if (!forUI) {
            if (!this.nonIndexingDimensions.isEmpty()) {
                OlapSchemaStats.println(sb, "");
                OlapSchemaStats.println(sb, "-- Non Indexing Dimensions -------------------------------------------- ");
                OlapSchemaStats.println(sb, "");
                for (String string : this.nonIndexingDimensions) {
                    OlapSchemaStats.println(sb, string);
                }
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Dimension Details -------------------------------------------------- ");
            Iterator<String> fieldsD = new OlapStatsFields();
            for (OlapDimensionStats dimension : this.dimensions) {
                ((OlapStatsFields)((Object)fieldsD)).addFields("D : " + dimension.getName(), "members: " + OlapSchemaStats.formatCount(dimension.getMemberCount()), "total-ram: " + OlapSchemaStats.formatSize(dimension.getRamSize()), "processing-time: " + OlapSchemaStats.formatMillis(dimension.getElapsedMS()));
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, ((OlapStatsFields)((Object)fieldsD)).toString());
            for (OlapDimensionStats dimension : this.dimensions) {
                OlapSchemaStats.printDimensionStats(sb, dimension);
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Facts Details -------------------------------------------------- ");
            OlapStatsFields olapStatsFields = new OlapStatsFields();
            for (OlapFactsStats facts : this.facts) {
                String sparsity;
                String cellCount;
                long rowCount = facts.getRowCount();
                Double cellCountValue = facts.getCellCount();
                if (cellCountValue != null) {
                    cellCount = OlapSchemaStats.formatScientific(cellCountValue);
                    sparsity = OlapSchemaStats.formatScientific((double)(100L * rowCount) / cellCountValue);
                } else {
                    cellCount = "n/a";
                    sparsity = "n/a";
                }
                ArrayList<String> fields = new ArrayList<String>();
                fields.add("F : " + facts.getName());
                fields.add("rows: " + OlapSchemaStats.formatCount(rowCount));
                fields.add("index-count: " + facts.getBitmapCount().formatCount());
                fields.add("index-ram: " + facts.getBitmapsRamSize().formatRamSize());
                if (facts.isIndexInFiles()) {
                    long filesSize = facts.getBitmapsRamSize().files;
                    fields.add("index-files: " + OlapSchemaStats.formatSize(filesSize));
                }
                fields.add(!factsInFiles ? "cols-ram: " + OlapSchemaStats.formatSize(facts.getColumnsRamSize()) : "cols-files: " + OlapSchemaStats.formatSize(facts.getColumnsFilesSize()));
                fields.add("u-rows: " + OlapSchemaStats.formatCount(facts.getUnresolvedRowCount()));
                fields.add("cell: " + cellCount);
                fields.add("sparsity: " + sparsity);
                olapStatsFields.add(fields);
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, olapStatsFields.toString());
            for (OlapFactsStats facts : this.facts) {
                String f3_1;
                String f0 = "F : " + facts.getName();
                String f1 = "rows: " + OlapSchemaStats.formatCount(facts.getRowCount());
                String f2 = "index-count: " + facts.getBitmapCount().formatCount();
                String f3 = "index-ram: " + facts.getBitmapsRamSize().formatRamSize();
                if (facts.isIndexInFiles()) {
                    long filesSize = facts.getBitmapsRamSize().files;
                    f3_1 = "index-files: " + OlapSchemaStats.formatSize(filesSize);
                } else {
                    f3_1 = null;
                }
                String f4 = !factsInFiles ? "cols-ram: " + OlapSchemaStats.formatSize(facts.getColumnsRamSize()) : "cols-files: " + OlapSchemaStats.formatSize(facts.getColumnsFilesSize());
                String f6 = "u-rows: " + OlapSchemaStats.formatCount(facts.getUnresolvedRowCount());
                String f7 = "temp-mem: " + OlapSchemaStats.formatSize(facts.getMetaTemporarySize());
                OlapSchemaStats.println(sb, "");
                OlapSchemaStats.println(sb, f0 + " :: " + f1 + ", " + f2 + ", " + f3 + (String)(f3_1 != null ? ", " + f3_1 : "") + ", " + f4 + ", " + f6 + ", " + f7);
                List<OlapFactsLevelsBitmapsStats.Stats> hierarchyStats = facts.getStatsPerLevel().getHierarchyNames().stream().map(o -> facts.getStatsPerLevel().getHierarchyX((String)o)).filter(Objects::nonNull).sorted(Comparator.comparing(OlapFactsLevelsBitmapsStats.Stats::getBitmapsSerializedSize).reversed()).toList();
                for (OlapFactsLevelsBitmapsStats.Stats stats : hierarchyStats) {
                    OlapSchemaStats.println(sb, "");
                    String hierarchyName = stats.getHierName();
                    OlapSchemaStats.print(sb, "  H : " + hierarchyName + " :: ");
                    OlapSchemaStats.print(sb, "index-count: " + OlapSchemaStats.formatCount(stats.getBitmapCount()));
                    OlapSchemaStats.print(sb, ", index-serialized: " + OlapSchemaStats.formatSize(stats.getBitmapsSerializedSize()));
                    OlapSchemaStats.println(sb, "");
                    OlapStatsFields fieldsL = new OlapStatsFields();
                    Map<String, OlapFactsLevelBitmapStats> levels = facts.getStatsPerLevel().getHierarchy(hierarchyName);
                    ArrayList<String> levelNames = new ArrayList<String>(levels.keySet());
                    levelNames.sort(Comparator.naturalOrder());
                    for (String levelName : levelNames) {
                        OlapFactsLevelBitmapStats lStats = levels.get(levelName);
                        fieldsL.addFields("    L : " + levelName, "index-member-count:" + OlapSchemaStats.formatCount(lStats.getMemberCount()), "index-serialized:" + OlapSchemaStats.formatSize(lStats.getBitmapsSerializedSize()));
                    }
                    OlapSchemaStats.println(sb, "");
                    OlapSchemaStats.println(sb, fieldsL.toString());
                }
                for (OlapFactsPartitionStats partition : facts.getPartitions()) {
                    if (facts.isPartitioned()) {
                        String p3_1;
                        String p0 = "  P : " + (facts.isLevelPartitioned() ? "(level) " : "") + partition.getName();
                        String p1 = "rows: " + OlapSchemaStats.formatCount(partition.getRowCount());
                        String p2 = "index-count: " + partition.getBitmapCount().formatCount();
                        String p3 = "index-ram: " + partition.getBitmapsRamSize().formatFileSize();
                        if (facts.isIndexInFiles()) {
                            long filesSize = partition.getBitmapsRamSize().files;
                            p3_1 = "index-files: " + OlapSchemaStats.formatSize(filesSize);
                        } else {
                            p3_1 = null;
                        }
                        String p4 = !factsInFiles ? "cols-ram: " + OlapSchemaStats.formatSize(partition.getColumnsRamSize()) : "cols-files: " + OlapSchemaStats.formatSize(partition.getColumnsFilesSize());
                        OlapSchemaStats.println(sb, "");
                        OlapSchemaStats.println(sb, p0 + " :: " + p1 + ", " + p2 + ", " + p3 + (String)(p3_1 != null ? ", " + p3_1 : "") + ", " + p4);
                    }
                    OlapStatsFields fieldsM = new OlapStatsFields();
                    for (OlapMeasureStats measure : partition.getMeasures()) {
                        fieldsM.addFields((facts.isPartitioned() ? "    " : "  ") + "M : " + measure.getName(), "aggr: " + measure.getAggregationType(), "data: " + measure.getDataType(), "col: " + measure.getColumnType(), !factsInFiles ? "ram: " + OlapSchemaStats.formatSize(measure.getRamSize()) : "files: " + OlapSchemaStats.formatSize(measure.getFilesSize()), measure.hasNulls() ? "+" : "-");
                    }
                    OlapSchemaStats.println(sb, "");
                    OlapSchemaStats.println(sb, fieldsM.toString());
                }
            }
        }
        if (this.savePoints != null && !this.savePoints.isEmpty()) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Incr. Load Save Points ----------------------------------------- ");
            for (OlapSavePointStats olapSavePointStats : this.savePoints) {
                OlapSchemaStats.println(sb, "");
                olapSavePointStats.print(sb, "");
            }
        }
        if (!this.warnings.isEmpty()) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Warnings (while processing the statistics) --------------------- ");
            OlapSchemaStats.println(sb, "");
            for (String string : this.warnings) {
                OlapSchemaStats.println(sb, string);
            }
        }
        if (!forUI && this.fullLoadStats != null) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Loading Details ------------------------------------------------ ");
            this.fullLoadStats.print(sb);
        }
        if (!forUI && this.tableStats != null) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- Table Details ------------------------------------------------ ");
            this.tableStats.print(sb);
        }
        if (!forUI && this.fullLoadGCStats != null) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "-- GC Details ------------------------------------------------ ");
            this.fullLoadGCStats.print(sb);
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "-- icCube Details ------------------------------------------------- ");
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Version             : " + OlapVersion.get().toString());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "-- JVM Details ---------------------------------------------------- ");
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "JVM                 : " + CdVirtualMachine.JVM_INFO_STRING);
        OlapSchemaStats.println(sb, "Java                : " + CdVirtualMachine.JAVA_INFO_STRING);
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Supported           : " + CdVirtualMachine.isSupportedJVM());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Object Ref.   Size  : " + CdVirtualMachine.NUM_BYTES_OBJECT_REF);
        OlapSchemaStats.println(sb, "Object Header Size  : " + CdVirtualMachine.NUM_BYTES_OBJECT_HEADER);
        OlapSchemaStats.println(sb, "Array Header  Size  : " + CdVirtualMachine.NUM_BYTES_ARRAY_HEADER);
        OlapSchemaStats.println(sb, "Object Alignment    : " + CdVirtualMachine.NUM_BYTES_OBJECT_ALIGNMENT);
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Integer Min. Cache  : " + CdVirtualMachine.INTEGER_CACHE_MIN_VALUE);
        OlapSchemaStats.println(sb, "Integer Max. Cache  : " + CdVirtualMachine.INTEGER_CACHE_MAX_VALUE);
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Long Min.    Cache  : " + CdVirtualMachine.LONG_CACHE_MIN_VALUE);
        OlapSchemaStats.println(sb, "Long Max.    Cache  : " + CdVirtualMachine.LONG_CACHE_MAX_VALUE);
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "Memory Max          : " + CdSizeUtils.format((double)Runtime.getRuntime().maxMemory()));
        OlapSchemaStats.println(sb, "Memory Total        : " + CdSizeUtils.format((double)Runtime.getRuntime().totalMemory()));
        OlapSchemaStats.println(sb, "Memory Free         : " + CdSizeUtils.format((double)Runtime.getRuntime().freeMemory()));
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "-- Machine Details ------------------------------------------------ ");
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "OS                  : " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        OlapSchemaStats.println(sb, "Processors          : " + CdSystemUtils.availableProcessorsForLogs());
        OlapSchemaStats.println(sb, "");
        long value = CdOperatingSystemUtils.getTotalPhysicalMemorySize();
        if (value != -1L) {
            OlapSchemaStats.println(sb, "RAM Total           : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getFreePhysicalMemorySize()) != -1L) {
            OlapSchemaStats.println(sb, "RAM Free            : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getTotalSwapSpaceSize()) != -1L) {
            OlapSchemaStats.println(sb, "Swap Total          : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getFreeSwapSpaceSize()) != -1L) {
            OlapSchemaStats.println(sb, "Swap Free           : " + CdSizeUtils.format((double)value));
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "-- Done ----------------------------------------------------------- ");
        return sb.toString();
    }

    private long getMaxMetaTemporarySize() {
        long max = 0L;
        for (OlapFactsStats fact : this.facts) {
            max = Math.max(max, fact.getMetaTemporarySize());
        }
        return max;
    }

    private long getSumMetaTemporarySize() {
        long max = 0L;
        for (OlapFactsStats fact : this.facts) {
            max += fact.getMetaTemporarySize();
        }
        return max;
    }

    public static void printDimensionStats(StringBuilder sb, OlapDimensionStats dimension) {
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "D : " + dimension.getName() + " :: members: " + OlapSchemaStats.formatCount(dimension.getMemberCount()) + ", processing-time: " + OlapSchemaStats.formatMillis(dimension.getElapsedMS()));
        for (OlapHierarchyStats hierarchy : dimension.getHierarchies()) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "  H : " + hierarchy.getName() + (hierarchy.isBase() ? " :: base(" + hierarchy.getIndex() + ")," : " :: (" + hierarchy.getIndex() + ")") + " members: " + OlapSchemaStats.formatCount(hierarchy.getMemberCount()) + (hierarchy.isHollow() ? " (Hollow)" : "") + ", exist-ram: " + OlapSchemaStats.formatSize(hierarchy.getAutoExistSize()));
            OlapStatsFields fieldsL = new OlapStatsFields();
            for (OlapLevelStats level : hierarchy.getLevels()) {
                if (level == null) continue;
                fieldsL.addFields("    L : " + level.getName(), "members: " + OlapSchemaStats.formatCount(level.getMemberCount()), "total-ram:" + OlapSchemaStats.formatSize(level.getRamSize()), "member-ram:" + OlapSchemaStats.formatSize(level.getMemberRamSize()), "parent-ram:" + OlapSchemaStats.formatSize(level.getParentRamSize()), "exist-ram:" + OlapSchemaStats.formatSize(level.getExistsRamSize()), "name-ram:" + OlapSchemaStats.formatSize(level.getNameRamSize()), "s-names-ram:" + OlapSchemaStats.formatSize(level.getNameSortedRamSize()), "keys-ram:" + OlapSchemaStats.formatSize(level.getKeyRamSize()), "s-keys-ram:" + OlapSchemaStats.formatSize(level.getKeySortedRamSize()), "props-ram:" + OlapSchemaStats.formatSize(level.getPropertyRamSize()), "noBase-ram:" + OlapSchemaStats.formatSize(level.getNoBaseRamSize()), "mightNotBeHollow-ram:" + OlapSchemaStats.formatSize(level.getMightNotBeHollowRamSize()), level.isHollow() ? "hollow" : "      ");
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, fieldsL.toString());
        }
    }

    public boolean isIndexInFiles() {
        for (OlapFactsStats fact : this.facts) {
            if (!fact.isIndexInFiles()) continue;
            return true;
        }
        return false;
    }

    public boolean isFactsInFiles() {
        for (OlapFactsStats fact : this.facts) {
            if (!fact.isFactsInFiles()) continue;
            return true;
        }
        return false;
    }

    public long getTotalRamSize() {
        return this.getTotalMemberRamSize() + this.getTotalMemberExistsRamSize() + this.getTotalUnresolvedRowRamSize() + this.getTotalFactsBitmapsRamSize().total + this.getTotalFactsColumnsRamSize() + this.getTotalSavePointsRamSize() + this.getTotalBridgeRamSize() + this.getTotalLookupTableRamSize();
    }

    public long getTotalDimensionCount() {
        return this.dimensions.size();
    }

    public long getTotalHierarchyCount() {
        long count = 0L;
        for (OlapDimensionStats dimension : this.dimensions) {
            count += dimension.getHierarchyCount();
        }
        return count;
    }

    public long getTotalLevelCount() {
        long count = 0L;
        for (OlapDimensionStats dimension : this.dimensions) {
            count += dimension.getLevelCount();
        }
        return count;
    }

    public long getTotalMemberCount() {
        long count = 0L;
        for (OlapDimensionStats dimension : this.dimensions) {
            count += dimension.getMemberCount();
        }
        return count;
    }

    public long getTotalMemberRamSize() {
        long count = 0L;
        for (OlapDimensionStats dimension : this.dimensions) {
            count += dimension.getRamSize();
        }
        return count;
    }

    public long getTotalMemberExistsRamSize() {
        return this.autoExistRamSize;
    }

    public long getTotalFactCount() {
        return this.facts.size();
    }

    public long getTotalTablePartitionCount() {
        long count = 0L;
        for (OlapFactsStats fact : this.facts) {
            if (!fact.isTablePartitioned()) continue;
            count += fact.getPartitionCount();
        }
        return count;
    }

    public long getTotalLevelPartitionCount() {
        long count = 0L;
        for (OlapFactsStats fact : this.facts) {
            if (!fact.isLevelPartitioned()) continue;
            count += fact.getPartitionCount();
        }
        return count;
    }

    public long getTotalRowCount() {
        long count = 0L;
        for (OlapFactsStats fact : this.facts) {
            count += fact.getRowCount();
        }
        return count;
    }

    public long getTotalUnresolvedRowCount() {
        return this.getTotalCubesUnresolvedRowCount();
    }

    public long getTotalCubesUnresolvedRowCount() {
        long count = 0L;
        for (OlapFactsStats fact : this.facts) {
            count += fact.getUnresolvedRowCount();
        }
        return count;
    }

    public long getTotalUnresolvedRowRamSize() {
        return this.getTotalCubesUnresolvedRowRamSize();
    }

    public long getTotalCubesUnresolvedRowRamSize() {
        long count = 0L;
        for (OlapFactsStats fact : this.facts) {
            count += fact.getUnresolvedRowRamSize();
        }
        return count;
    }

    public long getTotalSavePointsRamSize() {
        return this.savePointsRamSize;
    }

    public long getTotalBridgeRamSize() {
        return this.bridgeSize;
    }

    public long getTotalLookupTableRamSize() {
        return this.lookupTableSize;
    }

    public N_FactPageBitmapGutsBitmapCount getTotalFactsBitmapCount() {
        N_FactPageBitmapGutsBitmapCount count = new N_FactPageBitmapGutsBitmapCount();
        for (OlapFactsStats fact : this.facts) {
            count.add(fact.getBitmapCount());
        }
        return count;
    }

    public N_FactPageBitmapGutsSizeOf getTotalFactsBitmapsRamSize() {
        N_FactPageBitmapGutsSizeOf size = new N_FactPageBitmapGutsSizeOf();
        for (OlapFactsStats fact : this.facts) {
            size.add(fact.getBitmapsRamSize());
        }
        return size;
    }

    public long getTotalFactsColumnsRamSize() {
        long size = 0L;
        for (OlapFactsStats fact : this.facts) {
            size += fact.getColumnsRamSize();
        }
        return size;
    }

    public long getTotalFactsColumnsFilesSize() {
        long size = 0L;
        for (OlapFactsStats fact : this.facts) {
            size += fact.getColumnsFilesSize();
        }
        return size;
    }

    public OlapSchemaStatsStatus getStatus() {
        return this.status;
    }

    public void setStatus(OlapSchemaStatsStatus status) {
        this.status = status;
    }

    public static String formatMillis(long elapsed) {
        return elapsed != -1L ? CdTimeUtils.formatMillis((long)elapsed) : "-";
    }

    public static String formatTime(Date time) {
        return time.toString();
    }

    public static String formatCount(long value) {
        return CdStringUtils.formatNice((long)value);
    }

    public static String formatAverage(double value) {
        return CdStringUtils.formatAverage((double)value);
    }

    public static String formatSize(long value) {
        return CdSizeUtils.format((double)value);
    }

    public static String formatPercent(double fileSizeLost, double fileSize) {
        double value = fileSizeLost == 0.0 ? 0.0 : fileSizeLost / fileSize;
        return CdStringUtils.formatPercent((double)value);
    }

    public static String formatScientific(double value) {
        return CdStringUtils.formatScientific((double)value);
    }

    public static StringBuilder println(StringBuilder sb, String value) {
        return sb.append(value).append("\n");
    }

    public static StringBuilder print(StringBuilder sb, String value) {
        return sb.append(value);
    }
}

