/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapStatsFields;
import java.util.ArrayList;
import java.util.List;

public class OlapSchemaFullLoadStats {
    private final String configuration;
    private final List<OlapSchemaFactsBuilderStats> factsStats = new ArrayList<OlapSchemaFactsBuilderStats>();
    private volatile long memberMapperRamSize;
    private volatile long bridgeRamSize;
    private volatile long lookupTableRamSize;

    public OlapSchemaFullLoadStats(OlapProperties props) {
        this.configuration = OlapSchemaFullLoadStats.setupConfiguration(props);
    }

    public static String setupConfiguration(OlapProperties props) {
        return "RT:" + props.getLoadReadingThreadCount() + " PT:" + props.getLoadProcessingThreadCount() + " PQ:" + props.getLoadProcessingQueueSize();
    }

    public void onFactsProcessingStarted() {
    }

    public void onFactsProcessingCompleted(OlapBuilderContext context, OlapSchema schema) {
        this.memberMapperRamSize = context.memberMapperRamSize();
        this.bridgeRamSize = schema.bridgeSizeOf();
        this.lookupTableRamSize = schema.lookupTableSizeOf();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public long getMemberMapperRamSize() {
        return this.memberMapperRamSize;
    }

    public long getBridgeRamSize() {
        return this.bridgeRamSize;
    }

    public long getLookupTableRamSize() {
        return this.lookupTableRamSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSchemaFactsBuilderStats createStats(OlapRegularCube cube, OlapBuilderFacts facts) {
        OlapSchemaFactsBuilderStats stats = new OlapSchemaFactsBuilderStats(this.configuration, cube, facts);
        List<OlapSchemaFactsBuilderStats> list = this.factsStats;
        synchronized (list) {
            this.factsStats.add(stats);
        }
        return stats;
    }

    public void print(StringBuilder sb) {
        OlapStatsFields fieldsF = new OlapStatsFields();
        for (OlapSchemaFactsBuilderStats factsStat : this.factsStats) {
            fieldsF.addFields("F: " + factsStat.getName(), factsStat.formatElapsedTime());
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, fieldsF.toString());
        for (OlapSchemaFactsBuilderStats factsStat : this.factsStats) {
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, "F : " + factsStat.getName());
            factsStat.print(sb);
        }
    }
}

