/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapSavePointStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapIncrLoadStats {
    private final List<OlapDimensionStats> dimensions;
    private final List<OlapFactsStats> facts;
    private final List<OlapSavePointStats> savePoints;

    public OlapIncrLoadStats(List<OlapDimensionStats> dimensions, List<OlapFactsStats> facts, List<OlapSavePointStats> savePoints) {
        this.dimensions = dimensions;
        this.facts = facts;
        this.savePoints = savePoints;
    }

    public List<OlapDimensionStats> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    public OlapDimensionStats getDimension(String name) {
        for (OlapDimensionStats dimension : this.dimensions) {
            if (!OlapCaseInsensitiveName.equals(dimension.getName(), name)) continue;
            return dimension;
        }
        return null;
    }

    public List<OlapFactsStats> getFacts() {
        return this.facts;
    }

    @Nullable
    public OlapFactsStats getFacts(String name) {
        for (OlapFactsStats fact : this.facts) {
            if (!OlapCaseInsensitiveName.equals(fact.getName(), name)) continue;
            return fact;
        }
        return null;
    }

    public List<OlapSavePointStats> getSavePoints() {
        return this.savePoints;
    }
}

