/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import java.util.List;

public class OlapHierarchyStats {
    private final String name;
    private final int index;
    private final boolean base;
    private final List<OlapLevelStats> levels;
    private final long autoExistSize;
    private final boolean hollow;

    public OlapHierarchyStats(String name, int index, boolean base, boolean hollow, List<OlapLevelStats> levels, long autoExistSize) {
        this.name = name;
        this.index = index;
        this.base = base;
        this.hollow = hollow;
        this.levels = levels;
        this.autoExistSize = autoExistSize;
    }

    public long getAutoExistSize() {
        return this.autoExistSize;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isBase() {
        return this.base;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public List<OlapLevelStats> getLevels() {
        return this.levels;
    }

    public long getLevelCount() {
        return this.levels.size();
    }

    public long getMemberCount() {
        long count = 0L;
        for (OlapLevelStats level : this.levels) {
            count += level == null ? 0L : level.getMemberCount();
        }
        return count;
    }

    public long getRamSize() {
        long count = 0L;
        for (OlapLevelStats level : this.levels) {
            count += level == null ? 0L : level.getRamSize();
        }
        return count;
    }
}

