/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import java.util.ArrayList;
import java.util.List;

public class OlapFactsLevelBitmapStats {
    private final String hierarchy;
    private final String level;
    private final List<Partition> partitions = new ArrayList<Partition>();

    public OlapFactsLevelBitmapStats(String hierarchy, String level) {
        this.hierarchy = hierarchy;
        this.level = level;
    }

    public void addForPartition(long memberCount, long bitmapsSerializedSize) {
        this.partitions.add(new Partition(memberCount, bitmapsSerializedSize));
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public String getLevel() {
        return this.level;
    }

    public long getMemberCount() {
        long count = 0L;
        for (Partition partition : this.partitions) {
            count += partition.memberCount;
        }
        return count;
    }

    public long getBitmapsSerializedSize() {
        long count = 0L;
        for (Partition partition : this.partitions) {
            count += partition.bitmapsSerializedSize;
        }
        return count;
    }

    static class Partition {
        final long bitmapsSerializedSize;
        final long memberCount;

        public Partition(long memberCount, long bitmapsSerializedSize) {
            this.memberCount = memberCount;
            this.bitmapsSerializedSize = bitmapsSerializedSize;
        }
    }
}

