/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.colors;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.entity.result.model.IMember;
import crazydev.iccube.olap.schema.colors.OlapSchemaColors;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class OlapDefaultSchemaColors
extends OlapSchemaColors {
    private TreeLevel treeLevel = new TreeLevel("Dimension", IMember::getDimensionNameX);

    public OlapDefaultSchemaColors() {
        this.treeLevel.addLevel(new TreeLevel("Hierarchy", IMember::getHierarchyNameX)).addLevel(new TreeLevel("Level", IMember::getLevelNameX)).addLevel(new TreeLevel("Name", IMember::getNameX)).addLevel(new TreeLevel("UniqueName", IMember::getUniqueNameX));
    }

    @Override
    public void onProcessingStarted() {
    }

    @Override
    public void addColor(@Nullable Comparable color, @Nullable Comparable name, @Nullable Comparable level, @Nullable Comparable hierarchy, @Nullable Comparable dimension, @Nullable Comparable uniqueName) {
        this.doAddColor(color != null ? color.toString() : "", name != null ? name.toString().toLowerCase() : "", level != null ? level.toString().toLowerCase() : "", hierarchy != null ? hierarchy.toString().toLowerCase() : "", dimension != null ? dimension.toString().toLowerCase() : "", uniqueName != null ? uniqueName.toString().toLowerCase() : "");
    }

    private void doAddColor(String color, String name, String level, String hierarchy, String dimension, String uniqueName) {
        this.treeLevel.addColor(color, 0, dimension, hierarchy, level, name, uniqueName);
    }

    @Override
    public void onProcessingDone() {
        this.treeLevel = this.treeLevel.trim();
    }

    @Override
    @Nullable
    public String getColor(IMember member) {
        return this.treeLevel.getColor(member);
    }

    private static class TreeLevel
    extends TreeLevelInfo {
        public static final String WILDCARD = "";
        private final TreeMap<String, String> colors = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        private final Map<String, TreeLevel> nextTreeMap = new TreeMap<String, TreeLevel>(String.CASE_INSENSITIVE_ORDER);

        TreeLevel(String info, Function<IMember, String> getNameFor) {
            super(info, getNameFor);
        }

        TreeLevel(TreeLevelInfo copy) {
            super(copy.info, copy.getNameFor);
            this.nextLevelForInfo = copy.nextLevelForInfo;
        }

        TreeLevel addLevel(TreeLevel treeLevel) {
            this.nextLevelForInfo = treeLevel;
            return treeLevel;
        }

        @Nullable
        String getColor(IMember member) {
            TreeLevel wildCardLevel;
            String tagForLevel = (String)this.getNameFor.apply(member);
            if (tagForLevel != null) {
                String color;
                TreeLevel level = this.nextTreeMap.get(tagForLevel);
                if (level != null && (color = level.getColor(member)) != null) {
                    return color;
                }
                color = this.colors.get(tagForLevel);
                if (color != null) {
                    return color;
                }
            }
            if ((wildCardLevel = this.nextTreeMap.get(WILDCARD)) != null) {
                return wildCardLevel.getColor(member);
            }
            return null;
        }

        void addColor(String color, int idx, String ... levelTags) {
            String levelTag = levelTags[idx].trim();
            if (this.nextTagsAreEmpty(idx + 1, levelTags)) {
                this.colors.put(levelTag, color);
            } else {
                this.nextTreeMap.computeIfAbsent(levelTag, s -> new TreeLevel(this.nextLevelForInfo)).addColor(color, idx + 1, levelTags);
            }
        }

        @Nullable
        private TreeLevel getNextIfEmpty() {
            if (this.colors.isEmpty() && this.nextTreeMap.size() == 1 && this.nextTreeMap.get(WILDCARD) != null) {
                return this.nextTreeMap.get(WILDCARD);
            }
            return null;
        }

        private boolean nextTagsAreEmpty(int idx, String[] levelTags) {
            for (int i = idx; i < levelTags.length; ++i) {
                String levelTag = levelTags[i];
                if (!CdStringUtils.isNotNullAndNotBlank((String)levelTag)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "TreeLevel{info='" + this.info + "'}";
        }

        TreeLevel trim() {
            TreeLevel simplify = this.getNextIfEmpty();
            if (simplify != null) {
                return simplify.trim();
            }
            this.nextTreeMap.replaceAll((s, treeLevel1) -> treeLevel1.trim());
            return this;
        }
    }

    private static class TreeLevelInfo {
        final String info;
        final Function<IMember, String> getNameFor;
        protected TreeLevelInfo nextLevelForInfo;

        public TreeLevelInfo(String info, Function<IMember, String> getNameFor) {
            this.info = info;
            this.getNameFor = getNameFor;
        }
    }
}

