/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaHierarchyIndex;

public class OlapStaticSchemaHierarchyIndex
extends OlapSchemaHierarchyIndex {
    private final OlapHierarchy hierarchy;
    private volatile int value;
    private volatile OlapTupleDimensionality dimensionality;

    public OlapStaticSchemaHierarchyIndex(OlapHierarchy hierarchy, int value) {
        this.hierarchy = hierarchy;
        this.value = value;
        this.dimensionality = OlapTupleDimensionalityFactory.createForHierarchy(value);
    }

    @Override
    public void resetForDynamicHierarchy(int index) {
        this.value = index;
        this.dimensionality = OlapTupleDimensionalityFactory.createForHierarchy(this.value);
    }

    @Override
    public void resetForSchema(OlapSchema otherSchema, int nextHierarchyIndexOffset) {
        this.value += nextHierarchyIndexOffset;
        this.dimensionality = OlapTupleDimensionalityFactory.createForHierarchy(this.value);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OlapTupleDimensionality getDimensionality() {
        return this.dimensionality;
    }
}

