/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.common.collection.CdMultiIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaFunctionRepository {
    private final OlapFunctionRepository functionRepository;
    private final Map<String, OlapDeclaredFunction> declaredFunctions = new CdCaseInsensitiveHashMap();

    public OlapSchemaFunctionRepository(OlapFunctionRepository functionRepository) {
        this.functionRepository = functionRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __reset() {
        this.functionRepository.reset();
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            this.declaredFunctions.clear();
        }
    }

    public OlapFunctionRepository __getFunctionRepository() {
        return this.functionRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeclaredFunctionIfNotContained(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, OlapDeclaredFunction function) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            if (this.containsFunction(function.getName())) {
                throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_FUNCTION, new Serializable[]{function.getName()});
            }
            this.declaredFunctions.put(function.getName(), function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaredFunction(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            this.declaredFunctions.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDeclaredFunctions(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            this.declaredFunctions.clear();
        }
    }

    public boolean containsPostFixedFunction(String name) {
        boolean contains = this.functionRepository.containsPostFixedFunction(name);
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFunction(String name) {
        boolean contains = this.functionRepository.containsFunction(name);
        if (contains) {
            return true;
        }
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            return this.declaredFunctions.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapFunction lookupFunction(String name) {
        OlapFunction function = this.functionRepository.lookupFunction(name);
        if (function == null) {
            Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
            synchronized (map) {
                function = this.declaredFunctions.get(name);
            }
        }
        return function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapDeclaredFunction lookupDeclaredFunction(String name) {
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            return this.declaredFunctions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getAllFunctionNames() {
        Iterator<String> first = this.functionRepository.getAllFunctionNames().iterator();
        ArrayList<String> cloneDeclaredFunctions = new ArrayList<String>();
        Map<String, OlapDeclaredFunction> map = this.declaredFunctions;
        synchronized (map) {
            cloneDeclaredFunctions.addAll(this.declaredFunctions.keySet());
        }
        return new CdMultiIterator(new Iterator[]{first, cloneDeclaredFunctions.iterator()});
    }

    public OlapSchemaFunctionRepositorySnapshot createSnapshot() {
        return new OlapSchemaFunctionRepositorySnapshot(this);
    }
}

