/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.facts.roaring;

import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapOrTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferEmpty;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.BitmapFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapFactsBitmapRoaringBufferOrTor
implements IFactsBitmapOrTor {
    @Nullable
    private List<ImmutableRoaringBitmap> bitmaps;
    private OlapFactsBitmap asBitmap;
    private boolean needsRebuild = true;
    private boolean noAdds = true;
    private boolean isOne;

    @Override
    public boolean noAdds() {
        return this.noAdds;
    }

    @Override
    public void add(@Nullable OlapFactsBitmap bitmap) {
        if (bitmap == null || this.isOne || bitmap.isZero() || bitmap.isEmpty()) {
            return;
        }
        this.noAdds = false;
        if (bitmap.isNoEmpty()) {
            if (bitmap.isOne()) {
                this.isOne = true;
                this.asBitmap = bitmap;
                if (this.bitmaps != null) {
                    this.bitmaps.clear();
                }
                this.needsRebuild = false;
            } else {
                if (this.bitmaps == null) {
                    this.bitmaps = new ArrayList<ImmutableRoaringBitmap>();
                }
                this.bitmaps.add(((OlapFactsBitmapRoaringBuffer)bitmap).asRoaring());
                this.needsRebuild = true;
            }
        }
    }

    @Override
    public OlapFactsBitmap facts_asBitmap() {
        if (this.needsRebuild || this.asBitmap == null) {
            this.buildBitmap();
        }
        if (this.asBitmap == null) {
            throw new RuntimeException("internal error : bitmap inconsistency");
        }
        return this.asBitmap;
    }

    private synchronized void buildBitmap() {
        if (this.needsRebuild || this.asBitmap == null) {
            this.asBitmap = this.applyOr();
            this.needsRebuild = false;
        }
    }

    private OlapFactsBitmap applyOr() {
        OlapFactsBitmapRoaringBuffer res;
        if (this.bitmaps == null || this.bitmaps.isEmpty()) {
            res = OlapFactsBitmapRoaringBufferEmpty.INSTANCE;
        } else if (this.bitmaps.size() == 1) {
            res = new OlapFactsBitmapRoaringBuffer(this.bitmaps.getFirst());
        } else {
            MutableRoaringBitmap or = BitmapFastAggregation.or((ImmutableRoaringBitmap[])this.bitmaps.toArray(ImmutableRoaringBitmap[]::new));
            res = new OlapFactsBitmapRoaringBuffer(or);
        }
        return res;
    }
}

