/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.facts.concise;

public abstract class ConciseMaths {
    static final int ALL_ONES_LITERAL = -1;
    static final int ALL_ZEROS_LITERAL = Integer.MIN_VALUE;
    static final int SEQUENCE_BIT = 0x40000000;
    static final int SEQUENCE_MASK = -1073741825;

    public static int literalLengthMultiplication(int n) {
        return (n << 5) - n;
    }

    static boolean isLiteral(int word) {
        return (word & Integer.MIN_VALUE) != 0;
    }

    static boolean isOneSequence(int word) {
        return (word & 0xC0000000) == 0x40000000;
    }

    static boolean isZeroSequence(int word) {
        return (word & 0xC0000000) == 0;
    }

    static int getSequenceBlockCount(int word) {
        return word & 0x1FFFFFF;
    }

    static int getSequenceBitPos(int word) {
        return ((word & 0xBFFFFFFF) >>> 25) - 1;
    }

    static int getLiteral(int word) {
        if (ConciseMaths.isLiteral(word)) {
            return word;
        }
        int literal = 1 << (word >>> 25) >>> 1;
        return ConciseMaths.isZeroSequence(word) ? Integer.MIN_VALUE | literal : 0xFFFFFFFF & ~literal;
    }
}

