/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective.permissions;

import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.OlapBaseSchemaPermission;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveCubePermission;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveDimensionsPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveSchemaPermission
extends OlapBaseSchemaPermission {
    private final IOlapSchemaPermission permissions;
    private final OlapPerspective defaultPerspective;
    private final Map<OlapCube, IOlapCubePermission> cubePermissions = new ConcurrentHashMap<OlapCube, IOlapCubePermission>();
    private final Map<OlapCube, IOlapDimensionsPermission> dimPermissions = new ConcurrentHashMap<OlapCube, IOlapDimensionsPermission>();
    private final IOlapDimensionsPermission cubelessDimensionsPermissions;

    public OlapPerspectiveSchemaPermission(OlapSchema schema, IOlapSchemaPermission permissions, OlapPerspective defaultPerspective) {
        super(schema);
        this.permissions = permissions;
        this.defaultPerspective = defaultPerspective;
        this.cubelessDimensionsPermissions = defaultPerspective == null ? permissions.getDimensionsPermissions(null) : new OlapPerspectiveDimensionsPermission(permissions, defaultPerspective);
    }

    @Override
    public IOlapSchemaPermission security() {
        return this.permissions;
    }

    @Override
    @Nullable
    public S_FactPermsDef createClusterPerms() {
        throw new RuntimeException("internal error: inconsistent perspective permissions usage");
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isCreated() {
        return true;
    }

    @Override
    public boolean isIncremental() {
        return false;
    }

    @Override
    public IOlapSchemaPermission increment(String name) {
        throw new RuntimeException("internal error: incremental perspective permissions usage inconsistency");
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        throw new RuntimeException("internal error: incremental (incr-load) perspective permissions usage inconsistency");
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        throw new RuntimeException("internal error: incremental (load-partitions) perspective permissions usage inconsistency");
    }

    @Override
    public IOlapSchemaPermission increment(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        throw new RuntimeException("internal error: incremental (unload-partitions) perspective permissions usage inconsistency");
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public List<? extends OlapContextualError> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public OlapSchema getSchema() {
        return this.schema;
    }

    @Override
    public boolean isReadOnly() {
        return this.permissions.isReadOnly();
    }

    @Override
    public boolean isDrillthroughDenied() {
        return this.permissions.isDrillthroughDenied();
    }

    @Override
    public boolean isSetAuthorized(String namedSet) {
        return true;
    }

    @Override
    public boolean isReportingDataSourceAuthorized(OlapBuilderBaseDataSource dataSource) {
        return this.permissions.isReportingDataSourceAuthorized(dataSource);
    }

    @Override
    public boolean isCubeAuthorized(OlapCube cube) {
        return (this.defaultPerspective == null || this.defaultPerspective.isCubeVisible(cube)) && this.permissions.isCubeAuthorized(cube);
    }

    @Override
    public boolean isPerspectiveAuthorized(OlapPerspectiveCube perspective) {
        return this.permissions.isPerspectiveAuthorized(perspective);
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube olapCube) {
        OlapRegularCube regularCube = olapCube.getRegularCube();
        return this.doGetCubePermissions(regularCube);
    }

    private IOlapCubePermission doGetCubePermissions(OlapRegularCube regularCube) {
        IOlapCubePermission cubePermission = this.cubePermissions.get(regularCube);
        if (cubePermission == null) {
            cubePermission = this.createCubePermissions(regularCube);
        }
        return cubePermission;
    }

    private synchronized IOlapCubePermission createCubePermissions(OlapRegularCube regularCube) {
        IOlapCubePermission perms = this.cubePermissions.get(regularCube);
        if (perms != null) {
            return perms;
        }
        OlapPerspective perspective = regularCube.getPerspective();
        OlapPerspective appliedPerspective = perspective == null ? this.defaultPerspective : perspective;
        IOlapCubePermission cubePermission = appliedPerspective == null || appliedPerspective.isEmpty() ? this.permissions.getCubePermissions(regularCube) : new OlapPerspectiveCubePermission(this.permissions, appliedPerspective, regularCube);
        this.cubePermissions.put(regularCube, cubePermission);
        return cubePermission;
    }

    @Override
    public IOlapDimensionsPermission getDimensionsPermissions(@Nullable OlapCube cube) {
        if (cube == null) {
            return this.cubelessDimensionsPermissions;
        }
        IOlapDimensionsPermission dimensionsPermission = this.dimPermissions.get(cube);
        if (dimensionsPermission == null) {
            dimensionsPermission = this.createDimPermissions(cube);
        }
        return dimensionsPermission;
    }

    private synchronized IOlapDimensionsPermission createDimPermissions(OlapCube olapCube) {
        IOlapDimensionsPermission perms = this.dimPermissions.get(olapCube);
        if (perms != null) {
            return perms;
        }
        OlapPerspective perspective = olapCube.getPerspective();
        OlapPerspective appliedPerspective = perspective == null ? this.defaultPerspective : perspective;
        IOlapDimensionsPermission cubePermission = appliedPerspective == null || appliedPerspective.isEmpty() ? this.permissions.getDimensionsPermissions(olapCube) : new OlapPerspectiveDimensionsPermission(this.permissions, appliedPerspective);
        this.dimPermissions.put(olapCube, cubePermission);
        return cubePermission;
    }

    @Override
    public OlapRoleFactFilter getFactFilter() {
        return this.permissions.getFactFilter();
    }
}

