/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective.permissions;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDecoratingInvisibleMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDecoratingMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveMemberFilter;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveDimensionPermission;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OlapPerspectiveDimensionsPermission
implements IOlapDimensionsPermission {
    private final IOlapSchemaPermission permissions;
    private final IOlapDimensionsPermission dimensionsPermissions;
    private final OlapPerspective perspective;
    private final OlapPerspectiveMemberFilter actualMemberFilter;
    private final OlapPerspectiveMemberFilter actualInvisibleMemberFilter;
    private final Map<OlapDimension, OlapPerspectiveDimensionPermission> permissionCache = new ConcurrentHashMap<OlapDimension, OlapPerspectiveDimensionPermission>();

    public OlapPerspectiveDimensionsPermission(IOlapSchemaPermission permissions, OlapPerspective perspective) {
        this.permissions = permissions;
        this.dimensionsPermissions = permissions.getDimensionsPermissions(null);
        this.perspective = perspective;
        OlapMemberFilter permissionsFilter = this.dimensionsPermissions.getMemberFilter();
        OlapPerspectiveMemberFilter perspectiveFilter = perspective.getFilter();
        if (permissionsFilter == null) {
            this.actualMemberFilter = perspectiveFilter;
            this.actualInvisibleMemberFilter = perspectiveFilter;
        } else {
            this.actualMemberFilter = new OlapPerspectiveDecoratingMemberFilter(perspectiveFilter, permissionsFilter);
            this.actualInvisibleMemberFilter = new OlapPerspectiveDecoratingInvisibleMemberFilter(perspectiveFilter, permissionsFilter);
        }
    }

    @Override
    public boolean isDimensionAuthorized(OlapDimension dimension) {
        return this.perspective.isDimensionVisible(dimension) && this.dimensionsPermissions.isDimensionAuthorized(dimension);
    }

    @Override
    public IOlapDimensionPermission getDimensionPermissions(OlapDimension olapDimension) {
        OlapPerspectiveDimensionPermission permission = this.permissionCache.get(olapDimension);
        if (permission == null) {
            permission = this.create(olapDimension);
        }
        return permission;
    }

    private synchronized OlapPerspectiveDimensionPermission create(OlapDimension olapDimension) {
        IOlapDimensionPermission dimensionPermission = this.dimensionsPermissions.getDimensionPermissions(olapDimension);
        OlapPerspectiveDimensionPermission permission = new OlapPerspectiveDimensionPermission(olapDimension, dimensionPermission, this.perspective);
        this.permissionCache.put(olapDimension, permission);
        return permission;
    }

    @Override
    public OlapPerspectiveMemberFilter getMemberFilter() {
        return this.actualMemberFilter;
    }

    @Override
    public OlapMemberFilter getInvisibleMemberFilter() {
        return this.actualInvisibleMemberFilter;
    }

    @Override
    public OlapNameContext getNamingContext(OlapRequestNamesContext nameContext) {
        return this.perspective.getNamingContext(nameContext);
    }
}

