/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective.permissions;

import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveHierarchyPermission;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OlapPerspectiveDimensionPermission
implements IOlapDimensionPermission {
    private final OlapDimension olapDimension;
    private final IOlapDimensionPermission permissions;
    private final OlapPerspective perspective;
    private final Map<OlapHierarchy, IOlapHierarchyPermission> permissionCache = new ConcurrentHashMap<OlapHierarchy, IOlapHierarchyPermission>();

    public OlapPerspectiveDimensionPermission(OlapDimension olapDimension, IOlapDimensionPermission permissions, OlapPerspective perspective) {
        this.olapDimension = olapDimension;
        this.permissions = permissions;
        this.perspective = perspective;
    }

    @Override
    public OlapDimension getDimension() {
        return this.olapDimension;
    }

    @Override
    public boolean isHierarchyAuthorized(OlapHierarchy hierarchy) {
        return this.perspective.getFilter().isAccepting(hierarchy) && this.permissions.isHierarchyAuthorized(hierarchy);
    }

    @Override
    public boolean isHierarchyInvisible(OlapHierarchy hierarchy) {
        return !this.perspective.getFilter().isAccepting(hierarchy) && this.permissions.isHierarchyAuthorized(hierarchy);
    }

    @Override
    public IOlapHierarchyPermission getHierarchyPermission(OlapHierarchy olapHierarchy) {
        IOlapHierarchyPermission permission = this.permissionCache.get(olapHierarchy);
        if (permission == null) {
            permission = this.create(olapHierarchy);
        }
        return permission;
    }

    private synchronized IOlapHierarchyPermission create(OlapHierarchy olapHierarchy) {
        OlapPerspectiveHierarchyPermission permission = new OlapPerspectiveHierarchyPermission(olapHierarchy, this.permissions, this.perspective);
        this.permissionCache.put(olapHierarchy, permission);
        return permission;
    }
}

