/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxBinaryOperatorCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxUnaryOperatorCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveBinaryStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveDefaultStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveExpression;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveNameStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveUnaryStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveVisibilityStatement;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveBuilder;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDefaultDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenameDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveVisibilityDefinitionLine;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveParser {
    private final IOlapBuilderPerspectiveDef perspective;
    private final OlapEngineRequestContext requestContext;
    private final OlapSchema schema;
    private final OlapCube cube;

    public OlapPerspectiveParser(IOlapBuilderPerspectiveDef perspective, OlapEngineRequestContext requestContext, OlapSchema schema, OlapCube cube) {
        this.perspective = perspective;
        this.requestContext = requestContext;
        this.schema = schema;
        this.cube = cube;
    }

    public static OlapPerspectiveBuilder createPerspectiveBuilder(OlapNameContext nameContext, OlapEngineRequestContext engineRequestContext, OlapSchema schema, IOlapBuilderPerspectiveDef definition) throws CdMdxScannerException, MdxParserException, OlapEvaluationException {
        OlapRegularCube cube = definition.getOlapCube(nameContext, schema);
        if (cube == null) {
            cube = schema.getFirstCube();
        }
        return OlapPerspectiveParser.createPerspectiveBuilder(engineRequestContext, schema, cube, definition);
    }

    public static OlapPerspectiveBuilder createPerspectiveBuilder(OlapEngineRequestContext context, OlapSchema schema, OlapRegularCube cube, IOlapBuilderPerspectiveDef definition) throws CdMdxScannerException, MdxParserException, OlapEvaluationException {
        OlapPerspectiveParser parser = new OlapPerspectiveParser(definition, context, schema, cube);
        List<OlapPerspectiveDefinitionLine> allLines = parser.decompose(definition.getDefinition());
        OlapPerspectiveBuilder perspectiveFilterBuilder = new OlapPerspectiveBuilder(definition, cube);
        perspectiveFilterBuilder.addLines(allLines);
        return perspectiveFilterBuilder;
    }

    public List<OlapPerspectiveDefinitionLine> decompose(String mdx) throws CdMdxScannerException, MdxParserException {
        MdxPerspectiveExpression expr = this.parseMdxExpressions(mdx);
        ArrayList<OlapPerspectiveDefinitionLine> definitions = new ArrayList<OlapPerspectiveDefinitionLine>();
        if (expr != null) {
            this.decompose(definitions, expr);
        }
        return definitions;
    }

    @Nullable
    protected MdxPerspectiveExpression parseMdxExpressions(String mdx) throws CdMdxScannerException, MdxParserException {
        OlapEngineComponent olapEngine = this.requestContext.getOlapEngineComponent();
        OlapProperties properties = olapEngine.getProperties();
        OlapFunctionRepository functionRepository = olapEngine.getFunctionRepository();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager(true);
        MdxParsingContext context = new MdxParsingContext(properties, functionRepository, schemaFunctionRepository.createSnapshot(), memberPropertyManager, true);
        MdxPerspectiveExpression expr = MdxParser.parsePerspective(context, mdx, "no hash");
        return expr;
    }

    private void decompose(List<OlapPerspectiveDefinitionLine> definitions, MdxPerspectiveExpression expression) throws MdxParserException {
        List<MdxPerspectiveStatement> statements = expression.getStatements();
        for (MdxPerspectiveStatement statement : statements) {
            if (statement instanceof MdxPerspectiveUnaryStatement) {
                this.decomposeStatement(definitions, (MdxPerspectiveUnaryStatement)statement);
                continue;
            }
            if (statement instanceof MdxPerspectiveBinaryStatement) {
                this.decomposeStatement(definitions, (MdxPerspectiveBinaryStatement)statement);
                continue;
            }
            if (statement instanceof MdxPerspectiveNameStatement) {
                this.decomposeStatement(definitions, (MdxPerspectiveNameStatement)statement);
                continue;
            }
            if (statement instanceof MdxPerspectiveDefaultStatement) {
                this.decomposeStatement(definitions, (MdxPerspectiveDefaultStatement)statement);
                continue;
            }
            throw new CdProgrammingException("internal error : unexpected perspective statement : " + statement.getClass().getName());
        }
    }

    private void decomposeStatement(List<OlapPerspectiveDefinitionLine> definitions, MdxPerspectiveUnaryStatement statement) throws MdxParserException {
        this.decomposeStatementExpression(definitions, statement.getUnaryExpression());
    }

    private void decomposeStatement(List<OlapPerspectiveDefinitionLine> definitions, MdxPerspectiveBinaryStatement statement) throws MdxParserException {
        this.decomposeStatementExpression(definitions, statement.getBinaryExpression());
    }

    private void decomposeStatementExpression(List<OlapPerspectiveDefinitionLine> definitions, MdxExpression statementExpression) throws MdxParserException {
        if (statementExpression instanceof MdxUnaryOperatorCallExpression) {
            MdxUnaryOperatorCallExpression unary = (MdxUnaryOperatorCallExpression)statementExpression;
            boolean visible = MdxPerspectiveVisibilityStatement.getVisibility(unary.getFirstToken(), unary.getFirstToken().getKind());
            MdxExpression expression = unary.operand();
            this.addLine(definitions, expression, visible);
        } else if (statementExpression instanceof MdxBinaryOperatorCallExpression) {
            MdxBinaryOperatorCallExpression expression = (MdxBinaryOperatorCallExpression)statementExpression;
            this.decomposeStatementExpression(definitions, expression.left());
            boolean visible = MdxPerspectiveVisibilityStatement.getVisibility(expression.getFirstToken(), expression.getKind());
            MdxExpression right = expression.right();
            this.addLine(definitions, right, visible);
        } else {
            throw new MdxParserException(statementExpression.getFirstToken(), CdMdxErrorCode.PARSE_UNEXPECTED_PERSPECTIVE_EXPRESSION, new Serializable[0]);
        }
    }

    private void decomposeStatement(List<OlapPerspectiveDefinitionLine> definitions, MdxPerspectiveNameStatement statement) {
        MdxIdentifierExpression toExpression = statement.getTo();
        String name = toExpression.getLastPartAsString();
        MdxIdentifierExpression fromExpression = statement.getFrom();
        OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(this.requestContext);
        OlapNonScalarAbstractEntity result = helper.executePerspectiveExpression(this.schema, this.cube, this.perspective, fromExpression);
        if (result != null) {
            definitions.add(new OlapPerspectiveRenameDefinitionLine(statement.getFirstToken(), name, fromExpression.asMdx(), result));
        }
    }

    private void decomposeStatement(List<OlapPerspectiveDefinitionLine> definitions, MdxPerspectiveDefaultStatement statement) throws MdxParserException {
        MdxIdentifierExpression defaultExpression = statement.getDefaultMember();
        OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(this.requestContext);
        OlapNonScalarAbstractEntity result = helper.executePerspectiveExpression(this.schema, this.cube, this.perspective, defaultExpression);
        if (result instanceof OlapMember) {
            definitions.add(new OlapPerspectiveDefaultDefinitionLine(statement.getFirstToken(), (OlapMember)result));
        } else if (result != null) {
            throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_UNEXPECTED_PERSPECTIVE_DEFAULT_MEMBER, new Serializable[]{result.toString(), result.getFriendlyTypeName()});
        }
    }

    private void addLine(List<OlapPerspectiveDefinitionLine> definitions, MdxExpression expression, boolean visible) {
        OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(this.requestContext);
        OlapNonScalarAbstractEntity result = helper.executePerspectiveExpression(this.schema, this.cube, this.perspective, expression);
        if (result != null) {
            definitions.add(new OlapPerspectiveVisibilityDefinitionLine(expression.getFirstToken(), result, visible));
        }
    }
}

