/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapDeniedMeasureGroupMemberFilterHelper;
import crazydev.iccube.olap.eval.filter.dimension.OlapMeasureGroupMemberFilterHelper;
import crazydev.iccube.olap.goodies.perspective.OlapBitmapMemberFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveMemberFilter
extends OlapAbstractMemberFilter {
    private final String name;
    private final Map<OlapHierarchy, OlapMemberFilterByHierarchy> filters;
    private final OlapMeasureGroupMemberFilterHelper authorizedMeasureGroups;
    private final Map<OlapHierarchy, OlapMember> defaultMembers;

    public OlapPerspectiveMemberFilter(String name) {
        this.name = name;
        this.filters = new HashMap<OlapHierarchy, OlapMemberFilterByHierarchy>();
        this.authorizedMeasureGroups = new OlapDeniedMeasureGroupMemberFilterHelper();
        this.defaultMembers = new HashMap<OlapHierarchy, OlapMember>();
    }

    public OlapPerspectiveMemberFilter(OlapPerspectiveMemberFilter filter, String name) {
        this.name = name;
        this.filters = filter.filters;
        this.authorizedMeasureGroups = filter.authorizedMeasureGroups;
        this.defaultMembers = filter.defaultMembers;
    }

    @Override
    public boolean isNotFiltering(OlapHierarchy hierarchy) {
        return this.filters.get(hierarchy) == null;
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        boolean accepted = this.isAcceptingWithoutMeasureGroup(member);
        return this.authorizedMeasureGroups.isAuthorized(member, accepted);
    }

    private boolean isAcceptingWithoutMeasureGroup(OlapMember member) {
        OlapMemberFilterByHierarchy filter = this.filters.get(member.getHierarchy());
        return filter == null || filter.isAccepting(member);
    }

    public boolean isAccepting(OlapHierarchy hierarchy) {
        OlapMemberFilterByHierarchy filter = this.filters.get(hierarchy);
        return filter == null || filter.isAccepting();
    }

    @Override
    public boolean isAccepting(OlapLevel level) {
        OlapMemberFilterByHierarchy filter = this.filters.get(level.getHierarchy());
        return filter == null || filter.isAccepting(level);
    }

    @Override
    public OlapMember getRedefinedDefaultMember(OlapHierarchy hierarchy) {
        OlapMember defaultMember = this.getPerspectiveDefaultMember(hierarchy);
        return defaultMember != null ? defaultMember : hierarchy.getDefinedDefaultMember();
    }

    @Nullable
    protected final OlapMember getPerspectiveDefaultMember(OlapHierarchy hierarchy) {
        return this.defaultMembers.get(hierarchy);
    }

    @Override
    public String getName() {
        return "perspective-" + this.name;
    }

    void addEntity(OlapMeasureGroup measureGroup, boolean visible) {
        this.authorizedMeasureGroups.addMeasureGroup(measureGroup, visible);
    }

    void addEntity(OlapHierarchy hierarchy, boolean visible) {
        OlapMemberFilterByHierarchy filter = this.getOrCreate(hierarchy);
        filter = filter.setHierarchyVisible(visible);
        this.updateFilter(hierarchy, filter);
    }

    void addEntity(OlapLevel level, boolean visible) {
        OlapHierarchy olapHierarchy = level.getHierarchy();
        OlapMemberFilterByHierarchy filter = this.getOrCreate(olapHierarchy);
        filter = filter.addEntity(level, visible);
        this.updateFilter(olapHierarchy, filter);
    }

    void addEntity(OlapMember member, boolean visible) {
        OlapHierarchy olapHierarchy = member.getHierarchy();
        OlapMemberFilterByHierarchy filter = this.getOrCreate(olapHierarchy);
        filter = filter.addEntity(member, visible);
        this.updateFilter(olapHierarchy, filter);
    }

    private void updateFilter(OlapHierarchy hierarchy, OlapMemberFilterByHierarchy newFilter) {
        if (newFilter == null) {
            this.filters.remove(hierarchy);
        } else {
            this.filters.put(hierarchy, newFilter);
        }
    }

    private OlapMemberFilterByHierarchy getOrCreate(OlapHierarchy olapHierarchy) {
        OlapMemberFilterByHierarchy filter = this.filters.get(olapHierarchy);
        if (filter == null) {
            filter = new OlapMemberFilterByHierarchy(olapHierarchy, true);
            this.filters.put(olapHierarchy, filter);
        }
        return filter;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty() && this.defaultMembers.isEmpty();
    }

    public void addDefaultMember(OlapMember defaultMember) {
        this.defaultMembers.put(defaultMember.getHierarchy(), defaultMember);
    }

    private static class OlapMemberFilterByHierarchy {
        private final OlapHierarchy hierarchy;
        private final Set<OlapLevel> invisibleLevels = new HashSet<OlapLevel>();
        private final Set<OlapLevel> visibleLevels = new HashSet<OlapLevel>();
        private OlapBitmapMemberFilter invisibleMembers = new OlapBitmapMemberFilter();
        private boolean hierarchyVisible;

        public OlapMemberFilterByHierarchy(OlapHierarchy hierarchy, boolean hierarchyVisible) {
            this.hierarchy = hierarchy;
            this.hierarchyVisible = hierarchyVisible;
        }

        public boolean isAccepting(OlapMember member) {
            if (member.getHierarchy() != this.hierarchy) {
                throw new CdRuntimeException("Hierarchy inconsistency [" + ONames.uname4Log(this.hierarchy) + "] - [" + ONames.uname4Log(member.getHierarchy()) + "]");
            }
            if (!(this.hierarchyVisible && !this.invisibleLevels.contains(member.getLevel()) || this.visibleLevels.contains(member.getLevel()))) {
                return false;
            }
            return this.invisibleMembers == null || this.invisibleMembers.isAccepting(member);
        }

        public boolean isAccepting(OlapLevel level) {
            return this.hierarchyVisible && !this.invisibleLevels.contains(level);
        }

        public boolean isAccepting() {
            return this.hierarchyVisible;
        }

        @Nullable
        OlapMemberFilterByHierarchy setHierarchyVisible(boolean hierarchyVisible) {
            if (hierarchyVisible) {
                this.hierarchyVisible = true;
                this.invisibleLevels.clear();
                this.invisibleMembers = new OlapBitmapMemberFilter();
                return null;
            }
            this.hierarchyVisible = false;
            return this;
        }

        @Nullable
        private OlapMemberFilterByHierarchy asNullIfEmpty() {
            if (this.hierarchyVisible && this.invisibleLevels.isEmpty() && this.invisibleMembers.isEmpty()) {
                return null;
            }
            return this;
        }

        @Nullable
        OlapMemberFilterByHierarchy addEntity(OlapLevel level, boolean visible) {
            if (!this.hierarchyVisible && !visible) {
                return this.asNullIfEmpty();
            }
            OlapLevel locLevel = level;
            if (!visible) {
                do {
                    this.doAddLevel(locLevel, visible);
                } while ((locLevel = locLevel.getNextLevel()) != null);
            } else {
                do {
                    this.doAddLevel(locLevel, visible);
                } while ((locLevel = locLevel.getPreviousLevel()) != null);
            }
            return this.asNullIfEmpty();
        }

        private void doAddLevel(OlapLevel level, boolean visible) {
            if (visible) {
                this.invisibleLevels.remove(level);
                this.visibleLevels.add(level);
            } else {
                this.invisibleLevels.add(level);
                this.visibleLevels.remove(level);
            }
        }

        @Nullable
        OlapMemberFilterByHierarchy addEntity(OlapMember member, boolean visible) {
            if (!this.hierarchyVisible && !visible) {
                return this.asNullIfEmpty();
            }
            if (visible) {
                this.invisibleMembers.addVisibleMember(member);
                if (this.invisibleLevels.contains(member.getLevel())) {
                    OlapMember levelMember;
                    OlapIterator iter = member.getLevel().getMembers(null).getIterator(false);
                    iter.reset();
                    while ((levelMember = (OlapMember)iter.next()) != null) {
                        if (OlapMember.equal(member, levelMember)) continue;
                        this.invisibleMembers.addInvisibleMember(levelMember);
                    }
                    this.invisibleLevels.remove(member.getLevel());
                }
            } else if (!this.invisibleLevels.contains(member.getLevel())) {
                this.invisibleMembers.addInvisibleMember(member);
            }
            return this.asNullIfEmpty();
        }
    }
}

