/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.permissions.OlapPerspectiveSchemaPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveManager {
    private final OlapSchema olapSchema;
    private final List<OlapPerspectiveCube> perspectivesAsCubes = new ArrayList<OlapPerspectiveCube>();
    private final ConcurrentHashMap<IOlapSchemaPermission, OlapPerspectiveSchemaPermission> schemaPermissionCache = new ConcurrentHashMap();
    private boolean hasPerspectives = false;
    @Nullable
    private OlapPerspective defaultPerspective;

    public OlapPerspectiveManager(OlapSchema olapSchema) {
        this.olapSchema = olapSchema;
    }

    public void onSchemaPartitionsUnloaded(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.schemaPermissionCache.clear();
    }

    public void onSchemaPartitionsLoaded(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.schemaPermissionCache.clear();
    }

    public void onSchemaPartitionsLoadError() {
        this.schemaPermissionCache.clear();
    }

    public void onSchemaIncrLoaded(OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.schemaPermissionCache.clear();
    }

    public void onSchemaIncrLoadedOnError() {
        this.schemaPermissionCache.clear();
    }

    public void onScriptStatementApplied() {
        this.schemaPermissionCache.clear();
    }

    public void onSecurityPermissionsRemoved() {
        this.schemaPermissionCache.clear();
    }

    public boolean isEmpty() {
        return !this.hasPerspectives;
    }

    public int size() {
        return this.perspectivesAsCubes.size() + (this.defaultPerspective != null ? 1 : 0);
    }

    @Nullable
    public OlapPerspective getDefaultPerspective() {
        return this.defaultPerspective;
    }

    public List<OlapPerspectiveCube> getCubePerspectives() {
        return this.perspectivesAsCubes;
    }

    public void addPerspective(OlapPerspective perspective) {
        if (perspective.isDefault()) {
            this.defaultPerspective = perspective;
        } else {
            OlapRegularCube underlying = perspective.getCube();
            if (underlying == null) {
                throw new RuntimeException("internal error : missing cube in non-default perspective [" + perspective.getName() + "]");
            }
            this.perspectivesAsCubes.add(new OlapPerspectiveCube(perspective, underlying));
        }
        this.hasPerspectives = true;
    }

    public IOlapSchemaPermission decorateWithPerspective(IOlapSchemaPermission rolePermission) {
        if (!this.hasPerspectives) {
            return rolePermission;
        }
        OlapPerspectiveSchemaPermission schemaPermission = this.schemaPermissionCache.get(rolePermission);
        if (schemaPermission == null) {
            schemaPermission = this.create(rolePermission);
        }
        return schemaPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapPerspectiveSchemaPermission create(IOlapSchemaPermission rolePermission) {
        ConcurrentHashMap<IOlapSchemaPermission, OlapPerspectiveSchemaPermission> concurrentHashMap = this.schemaPermissionCache;
        synchronized (concurrentHashMap) {
            OlapPerspectiveSchemaPermission schemaPermission = this.schemaPermissionCache.get(rolePermission);
            if (schemaPermission == null) {
                schemaPermission = new OlapPerspectiveSchemaPermission(this.olapSchema, rolePermission, this.defaultPerspective);
                this.schemaPermissionCache.put(rolePermission, schemaPermission);
            }
            return schemaPermission;
        }
    }
}

