/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapCubeEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDefaultDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenameDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenames;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveVisibilityDefinitionLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveBuilder {
    private final String name;
    private final boolean isDefault;
    @Nullable
    private final OlapRegularCube cube;
    private final List<OlapPerspectiveVisibilityDefinitionLine> visibilityLines = new ArrayList<OlapPerspectiveVisibilityDefinitionLine>();
    private final List<OlapPerspectiveRenameDefinitionLine> renameLines = new ArrayList<OlapPerspectiveRenameDefinitionLine>();
    private final List<OlapPerspectiveDefaultDefinitionLine> defaultLines = new ArrayList<OlapPerspectiveDefaultDefinitionLine>();

    public OlapPerspectiveBuilder(IOlapBuilderPerspectiveDef def, @Nullable OlapRegularCube cube) {
        this(def.getName(), def.isDefault(), cube);
    }

    public OlapPerspectiveBuilder(String name, boolean isDefault, @Nullable OlapRegularCube cube) {
        this.name = name;
        this.isDefault = isDefault;
        this.cube = cube;
    }

    public OlapPerspectiveBuilder(String name, boolean isDefault) {
        this.isDefault = isDefault;
        this.name = name;
        this.cube = null;
    }

    public void addLines(List<OlapPerspectiveDefinitionLine> lines) {
        for (OlapPerspectiveDefinitionLine line : lines) {
            this.addLine(line);
        }
    }

    public void addLine(OlapPerspectiveDefinitionLine line) {
        if (line instanceof OlapPerspectiveVisibilityDefinitionLine) {
            this.visibilityLines.add((OlapPerspectiveVisibilityDefinitionLine)line);
        } else if (line instanceof OlapPerspectiveRenameDefinitionLine) {
            this.renameLines.add((OlapPerspectiveRenameDefinitionLine)line);
        } else if (line instanceof OlapPerspectiveDefaultDefinitionLine) {
            this.defaultLines.add((OlapPerspectiveDefaultDefinitionLine)line);
        }
    }

    public OlapPerspective build() throws MdxParserException {
        OlapPerspectiveMemberFilter memberFilter = new OlapPerspectiveMemberFilter(this.name);
        OlapPerspectiveRenames renames = new OlapPerspectiveRenames();
        OlapPerspective perspective = new OlapPerspective(this.cube, this.isDefault, this.name, this.visibilityLines, this.renameLines, this.defaultLines, memberFilter, renames);
        this.buildMemberFilter(perspective, memberFilter);
        this.buildRenames(perspective, renames);
        this.buildDefaults(perspective, memberFilter);
        return perspective;
    }

    private void buildDefaults(OlapPerspective perspective, OlapPerspectiveMemberFilter memberFilter) {
        for (OlapPerspectiveDefaultDefinitionLine defaultLine : this.defaultLines) {
            memberFilter.addDefaultMember(defaultLine.getDefaultMember());
        }
    }

    private void buildMemberFilter(final OlapPerspective perspective, final OlapPerspectiveMemberFilter memberFilter) throws MdxParserException {
        for (final OlapPerspectiveVisibilityDefinitionLine visibilityLine : this.visibilityLines) {
            visibilityLine.forEachMember(new OlapPerspectiveVisibilityDefinitionLine.Visitor(){
                final /* synthetic */ OlapPerspectiveBuilder this$0;
                {
                    OlapPerspectiveBuilder olapPerspectiveBuilder = this$0;
                    Objects.requireNonNull(olapPerspectiveBuilder);
                    this.this$0 = olapPerspectiveBuilder;
                }

                @Override
                public void visit(OlapNonScalarAbstractEntity mdxEntity, boolean isVisible) throws MdxParserException {
                    if (mdxEntity instanceof OlapMember) {
                        OlapMember member = (OlapMember)mdxEntity;
                        memberFilter.addEntity(member, isVisible);
                    } else if (mdxEntity instanceof OlapDimension) {
                        OlapDimension dimension = (OlapDimension)mdxEntity;
                        perspective.addEntity(dimension, isVisible);
                        for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                            memberFilter.addEntity(hierarchy, isVisible);
                        }
                    } else if (mdxEntity instanceof OlapHierarchy) {
                        OlapHierarchy hierarchy = (OlapHierarchy)mdxEntity;
                        memberFilter.addEntity(hierarchy, isVisible);
                    } else if (mdxEntity instanceof OlapLevel) {
                        OlapLevel level = (OlapLevel)mdxEntity;
                        memberFilter.addEntity(level, isVisible);
                    } else if (mdxEntity instanceof OlapMeasureGroup) {
                        OlapMeasureGroup measureGroup = (OlapMeasureGroup)mdxEntity;
                        perspective.addEntity(measureGroup, isVisible);
                        memberFilter.addEntity(measureGroup, isVisible);
                        for (OlapMeasureMember measureMember : measureGroup.getMeasures()) {
                            memberFilter.addEntity(measureMember, isVisible);
                        }
                    } else if (mdxEntity instanceof OlapCubeEntity) {
                        OlapCubeEntity cube = (OlapCubeEntity)mdxEntity;
                        perspective.addEntity(cube, isVisible);
                    } else {
                        this.this$0.throwInvalidEntityType(visibilityLine, mdxEntity);
                    }
                }
            });
        }
    }

    private void buildRenames(OlapPerspective perspective, OlapPerspectiveRenames renames) throws MdxParserException {
        for (OlapPerspectiveRenameDefinitionLine renameLine : this.renameLines) {
            OlapNonScalarAbstractEntity mdxEntity = renameLine.getEntity();
            if (mdxEntity instanceof OlapDimension) {
                OlapDimension dimension = (OlapDimension)mdxEntity;
                this.validateRenameDimension(renames, renameLine, dimension);
                renames.addName(renameLine.getName(), dimension);
                continue;
            }
            if (mdxEntity instanceof OlapHierarchy) {
                OlapHierarchy hierarchy = (OlapHierarchy)mdxEntity;
                this.validateRenameHierarchy(renames, renameLine, hierarchy);
                renames.addName(renameLine.getName(), hierarchy);
                continue;
            }
            if (mdxEntity instanceof OlapLevel) {
                OlapLevel level = (OlapLevel)mdxEntity;
                this.validateRenameLevel(renames, renameLine, level);
                renames.addName(renameLine.getName(), level);
                continue;
            }
            if (mdxEntity instanceof OlapMember) {
                OlapMember member = (OlapMember)mdxEntity;
                this.validateRenameMember(renames, renameLine, member);
                renames.addName(renameLine.getName(), member);
                continue;
            }
            this.throwInvalidEntityType(renameLine, mdxEntity);
        }
    }

    private void validateRenameDimension(OlapPerspectiveRenames renames, OlapPerspectiveRenameDefinitionLine renameLine, OlapDimension dimension) {
        if (renames.getName(dimension) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_DUPLICATED_DIMENSION_RENAME, new Serializable[]{renameLine.getEntityMdx()});
        }
        if (renames.containsDimensionName(renameLine.getName())) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_MULTIPLE_DIMENSION_RENAME, new Serializable[]{renameLine.getName()});
        }
        if (this.cube != null && this.cube.lookupDimensionByName(OlapNameContext.DEFAULT_VALUES, renameLine.getName()) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_EXISTING_DIMENSION_RENAME, new Serializable[]{renameLine.getName()});
        }
    }

    private void validateRenameHierarchy(OlapPerspectiveRenames renames, OlapPerspectiveRenameDefinitionLine renameLine, OlapHierarchy hierarchy) {
        if (renames.getName(hierarchy) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_DUPLICATED_HIERARCHY_RENAME, new Serializable[]{renameLine.getEntityMdx()});
        }
        if (renames.containsHierarchyName(hierarchy.getDimension(), renameLine.getName())) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_MULTIPLE_HIERARCHY_RENAME, new Serializable[]{renameLine.getName()});
        }
        OlapDimension dimension = hierarchy.getDimension();
        if (dimension.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, renameLine.getName()) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_EXISTING_HIERARCHY_RENAME, new Serializable[]{renameLine.getName()});
        }
    }

    private void validateRenameLevel(OlapPerspectiveRenames renames, OlapPerspectiveRenameDefinitionLine renameLine, OlapLevel level) {
        if (renames.getName(level) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_DUPLICATED_LEVEL_RENAME, new Serializable[]{renameLine.getEntityMdx()});
        }
        if (renames.containsLevelName(level.getHierarchy(), renameLine.getName())) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_MULTIPLE_LEVEL_RENAME, new Serializable[]{renameLine.getName()});
        }
        OlapHierarchy hierarchy = level.getHierarchy();
        if (hierarchy.unfilteredLookupLevelByName(OlapNameContext.DEFAULT_VALUES, renameLine.getName()) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_EXISTING_LEVEL_RENAME, new Serializable[]{renameLine.getName()});
        }
    }

    private void validateRenameMember(OlapPerspectiveRenames renames, OlapPerspectiveRenameDefinitionLine renameLine, OlapMember member) {
        OlapMember memberParent;
        if (renames.getName(member) != null) {
            throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_DUPLICATED_MEMBER_RENAME, new Serializable[]{renameLine.getEntityMdx()});
        }
        OlapLevel level = member.getLevel();
        if (level.checkNamesUniqueInLevel()) {
            if (renames.containsMemberName(level, renameLine.getName())) {
                throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_MULTIPLE_MEMBER_RENAME_LEVEL, new Serializable[]{renameLine.getName()});
            }
            if (level.lookupMemberByName(renameLine.getName()) != null) {
                throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_EXISTING_MEMBER_RENAME_LEVEL, new Serializable[]{renameLine.getName()});
            }
        }
        if (level.checkNameUniqueInParent() && !level.checkNamesUniqueInLevel() && (memberParent = member.getParent()) != null) {
            if (renames.containsMemberName(memberParent, renameLine.getName())) {
                throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_MULTIPLE_MEMBER_RENAME_PARENT, new Serializable[]{renameLine.getName()});
            }
            if (memberParent.lookupChildByNameIgnoreCase(renameLine.getName()) != null) {
                throw new OlapEvaluationException(this.createErrorLocation(renameLine), OlapErrorCode.PERSPECTIVE_EXISTING_MEMBER_RENAME_PARENT, new Serializable[]{renameLine.getName()});
            }
        }
    }

    private OlapErrorLocation createErrorLocation(OlapPerspectiveRenameDefinitionLine renameLine) {
        CdMdxToken firstToken = renameLine.getFirstToken();
        String mdx = firstToken == null ? "rename" : firstToken.getMdx();
        String mdxHash = firstToken == null ? "?" : firstToken.getMdxHash();
        int from = firstToken == null ? -1 : firstToken.getStartOffset();
        int to = firstToken == null ? -1 : firstToken.getEndOffset();
        int lineNumber = firstToken == null ? -1 : firstToken.getLineNumber();
        return new OlapInstrLocationRange(mdx, mdxHash, from, to, lineNumber);
    }

    private void throwInvalidEntityType(OlapPerspectiveDefinitionLine line, OlapNonScalarAbstractEntity mdxEntity) throws MdxParserException {
        CdMdxToken firstToken = line.getFirstToken();
        int lineNumber = firstToken == null ? -1 : firstToken.getLocation().lineNumber();
        throw new MdxParserException(firstToken, CdMdxErrorCode.PARSE_PERSPECTIVE_INVALID_TYPE, new Serializable[]{mdxEntity.getFriendlyTypeName(), Integer.valueOf(lineNumber), mdxEntity.toMdxString(null, true, 100)});
    }
}

