/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapPerspectiveNamesContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapCubeEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveDefaultDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenameDefinitionLine;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenames;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveVisibilityDefinitionLine;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapPerspective {
    @Nullable
    private final OlapRegularCube cube;
    private final String name;
    private final boolean isDefault;
    private final List<OlapPerspectiveVisibilityDefinitionLine> visibilityLineDefinitions;
    private final List<OlapPerspectiveRenameDefinitionLine> renameLineDefinitions;
    private final OlapPerspectiveMemberFilter memberFilter;
    private final Set<OlapDimension> invisibleDimensions = new HashSet<OlapDimension>();
    private final Set<OlapCube> invisibleCubes = new HashSet<OlapCube>();
    private final Set<OlapMeasureGroup> invisibleMeasureGroups = new HashSet<OlapMeasureGroup>();
    private final OlapPerspectiveRenames renames;
    private final List<OlapPerspectiveDefaultDefinitionLine> defaultLineDefinitions;

    public OlapPerspective(@Nullable OlapRegularCube cube, boolean isDefault, String name, List<OlapPerspectiveVisibilityDefinitionLine> visibilityLineDefinitions, List<OlapPerspectiveRenameDefinitionLine> renameLineDefinitions, List<OlapPerspectiveDefaultDefinitionLine> defaultLineDefinitions, OlapPerspectiveMemberFilter memberFilter, OlapPerspectiveRenames renames) {
        this.cube = isDefault ? null : cube;
        this.name = name;
        this.isDefault = isDefault;
        this.visibilityLineDefinitions = visibilityLineDefinitions;
        this.renameLineDefinitions = renameLineDefinitions;
        this.defaultLineDefinitions = defaultLineDefinitions;
        this.memberFilter = memberFilter;
        this.renames = renames;
    }

    public List<OlapPerspectiveVisibilityDefinitionLine> getVisibilityLineDefinitions() {
        return this.visibilityLineDefinitions;
    }

    public List<OlapPerspectiveRenameDefinitionLine> getRenameLineDefinitions() {
        return this.renameLineDefinitions;
    }

    public List<OlapPerspectiveDefaultDefinitionLine> getDefaultLineDefinitions() {
        return this.defaultLineDefinitions;
    }

    public boolean isEmpty() {
        return this.memberFilter.isEmpty() && this.renames.isEmpty() && this.invisibleCubes.isEmpty() && this.invisibleDimensions.isEmpty() && this.invisibleMeasureGroups.isEmpty();
    }

    public OlapPerspectiveMemberFilter getFilter() {
        return this.memberFilter;
    }

    public boolean isCubeVisible(OlapCube cube) {
        return !this.invisibleCubes.contains(cube);
    }

    public boolean isLevelVisible(OlapLevel level) {
        return this.memberFilter.isAccepting(level);
    }

    public boolean isDimensionVisible(OlapDimension dimension) {
        return !this.invisibleDimensions.contains(dimension);
    }

    public boolean isMeasureGroupVisible(OlapCube olapCube, String measureGroupName) {
        return !this.invisibleMeasureGroups.contains(new OlapMeasureGroup(olapCube, measureGroupName));
    }

    protected void addEntity(OlapDimension dimension, boolean visible) {
        if (visible) {
            this.invisibleDimensions.remove(dimension);
        } else {
            this.invisibleDimensions.add(dimension);
        }
    }

    protected void addEntity(OlapCubeEntity cube, boolean visible) {
        if (visible) {
            this.invisibleCubes.remove(cube.getCube());
        } else {
            this.invisibleCubes.add(cube.getCube());
        }
    }

    protected void addEntity(OlapMeasureGroup measureGroup, boolean visible) {
        if (visible) {
            this.invisibleMeasureGroups.remove(measureGroup);
        } else {
            this.invisibleMeasureGroups.add(measureGroup);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapRegularCube getCube() {
        return this.cube;
    }

    public OlapNameContext getNamingContext(OlapRequestNamesContext nameContext) {
        return new OlapPerspectiveNamesContext(nameContext, this.renames);
    }
}

