/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.incrload;

import crazydev.iccube.olap.goodies.incrload.IncrLoadInstanceManager;
import java.util.Iterator;
import java.util.LinkedList;

public class IncrLoadLimitedInstanceManager
extends IncrLoadInstanceManager {
    private final long periodMs;
    private final int max;
    private final LinkedList<Long> latestIncrLoad = new LinkedList();

    public IncrLoadLimitedInstanceManager(long periodMs, int max) {
        this.periodMs = periodMs;
        this.max = max;
    }

    @Override
    public boolean isRealTime() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIncrLoadSucceeded() {
        long now = System.currentTimeMillis();
        LinkedList<Long> linkedList = this.latestIncrLoad;
        synchronized (linkedList) {
            this.latestIncrLoad.addFirst(now);
            if (this.latestIncrLoad.size() > this.max) {
                this.latestIncrLoad.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIncrLoad() {
        long nowMS = System.currentTimeMillis();
        LinkedList<Long> linkedList = this.latestIncrLoad;
        synchronized (linkedList) {
            long currentPeriodStartMS;
            if (this.latestIncrLoad.size() < this.max) {
                return true;
            }
            long oldestMS = this.latestIncrLoad.getLast();
            boolean bl = oldestMS <= (currentPeriodStartMS = nowMS - this.periodMs);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String incrLoads() {
        long now = System.currentTimeMillis();
        LinkedList<Long> linkedList = this.latestIncrLoad;
        synchronized (linkedList) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.max).append("/").append(this.periodMs);
            sb.append(" [ now : ").append(now).append(" - loads : ");
            boolean first = true;
            Iterator iterator = this.latestIncrLoad.iterator();
            while (iterator.hasNext()) {
                long load = (Long)iterator.next();
                if (!first) {
                    sb.append(", ");
                }
                sb.append(load);
                first = false;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

