/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.utils;

import crazydev.iccube.olap.entity.result.OlapResDrillthroughStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionHeader;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionRow;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class OlapDrillthroughResultPrettyPrinter {
    private final OlapResDrillthroughStatementDataSet result;

    public OlapDrillthroughResultPrettyPrinter(OlapResDrillthroughStatementDataSet result) {
        this.result = result;
    }

    public void print(PrintWriter out) {
        if (this.result.getCollection() == null) {
            out.print("BLANK");
            return;
        }
        List<Integer> widths = this.setupWidths();
        OlapDrillthroughCollection collection = this.result.getCollection();
        OlapDrillthroughCollectionHeader header = collection.getHeader();
        out.println("-");
        out.println("actual row count : " + collection.getActualCollectedRowsCount());
        out.println(" total row count : " + collection.getDrillthroughRowsCount());
        out.println("-");
        int pos = 0;
        for (String identifier : header.getIdentifiers()) {
            if (pos > 0) {
                out.print(",");
            }
            out.print(String.format("%-" + String.valueOf(widths.get(pos++)) + "s", identifier));
        }
        out.println();
        out.println("-");
        for (OlapDrillthroughCollectionRow row : collection.getRows()) {
            List<OlapScalarEntity> entities = row.getEntities();
            for (int idx = 0; idx < entities.size(); ++idx) {
                if (idx > 0) {
                    out.print(",");
                }
                OlapScalarEntity entity = entities.get(idx);
                String str = entity.asXmlaString();
                out.print(String.format("%-" + String.valueOf(widths.get(idx)) + "s", str));
            }
            out.println();
        }
        out.println();
    }

    private List<Integer> setupWidths() {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        OlapDrillthroughCollection collection = this.result.getCollection();
        OlapDrillthroughCollectionHeader header = collection.getHeader();
        for (String identifier : header.getIdentifiers()) {
            widths.add(identifier.length());
        }
        for (OlapDrillthroughCollectionRow row : collection.getRows()) {
            List<OlapScalarEntity> entities = row.getEntities();
            for (int idx = 0; idx < entities.size(); ++idx) {
                OlapScalarEntity entity = entities.get(idx);
                String str = entity.asXmlaString();
                int setLen = str.length();
                if (setLen <= (Integer)widths.get(idx)) continue;
                widths.set(idx, setLen);
            }
        }
        return widths;
    }
}

