/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.returns;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughFunctionReturnExpression;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMultiKeyReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughSingleKeyReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughFunctionReturn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughKeyFunctionReturn
extends OlapDrillthroughFunctionReturn {
    public static final String NAME = "Key";
    @Nullable
    private OlapInstr keyPartInstr;
    @Nullable
    private Integer keyPart;

    public OlapDrillthroughKeyFunctionReturn(MdxDrillthroughFunctionReturnExpression returnExpression, List<OlapInstr> arguments) {
        super(returnExpression, arguments);
        this.keyPartInstr = arguments.size() > 1 ? arguments.get(1) : null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void assertArgumentCount(OlapEvaluationContext context) {
        if (this.arguments.size() != 1 && this.arguments.size() != 2) {
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_UNEXPECTED_FUNCTION_ARGUMENT_COUNT, new Serializable[]{Integer.valueOf(this.arguments.size()), "[1..2]"});
        }
    }

    @Override
    protected void setup(OlapEvaluationContext context, OlapDimension dimension) {
        this.keyPart = this.keyPartInstr != null ? Integer.valueOf(this.setupKeyValue(context, this.keyPartInstr)) : null;
    }

    private int setupKeyValue(OlapEvaluationContext context, OlapInstr keyPartInstr) {
        OlapNumericEntity numericEntity;
        OlapEntity keyPart = keyPartInstr.execute(context);
        if (keyPart instanceof OlapNumericEntity && (numericEntity = (OlapNumericEntity)keyPart).isDecimal()) {
            return numericEntity.intValue();
        }
        throw new OlapEvaluationException(keyPartInstr.getLocationRange(), OlapErrorCode.DRILLTHROUGH_KEY_PART_TYPE_MISMATCH, new Serializable[]{keyPart.getFriendlyTypeName()});
    }

    @Override
    public List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext) {
        return this.createProcessors(nameContext, true, true, this.dimension, this.keyPart);
    }

    private List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext, boolean specifiedInRequest, boolean forKeyFunction, OlapDimension dimension, @Nullable Integer keyPart) {
        ArrayList<OlapDrillthroughReturnProcessor> processors = new ArrayList<OlapDrillthroughReturnProcessor>();
        if (keyPart != null) {
            processors.add(new OlapDrillthroughSingleKeyReturnProcessor(nameContext, specifiedInRequest, this.getUserDefinedColumnName(), forKeyFunction, dimension, keyPart));
        } else {
            processors.add(new OlapDrillthroughMultiKeyReturnProcessor(nameContext, specifiedInRequest, this.getUserDefinedColumnName(), forKeyFunction, dimension));
        }
        return processors;
    }
}

