/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.returns;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughFunctionReturnExpression;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberInstrReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberNameReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberTupleReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberUniqueNameReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCellReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughKeyFunctionReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughNameFunctionReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughPartitionIdReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughRowIdReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughUniqueNameFunctionReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughUnknownFunctionReturn;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDrillthroughFunctionReturn
extends OlapDrillthroughReturn {
    private static final Map<String, ReturnBuilder> builders = new CdCaseInsensitiveHashMap();
    protected final MdxDrillthroughFunctionReturnExpression myReturnExpression;
    protected final List<OlapInstr> arguments;
    @Nullable
    protected final OlapInstr attributeInstr;
    @Nullable
    protected OlapDimension dimension;

    protected OlapDrillthroughFunctionReturn(MdxDrillthroughFunctionReturnExpression returnExpression, List<OlapInstr> arguments) {
        super(returnExpression);
        this.myReturnExpression = returnExpression;
        this.arguments = arguments;
        this.attributeInstr = !arguments.isEmpty() ? arguments.getFirst() : null;
    }

    public static OlapDrillthroughFunctionReturn create(MdxDrillthroughFunctionReturnExpression returnExpression, List<OlapInstr> arguments) {
        String name = returnExpression.getName();
        ReturnBuilder builder = builders.get(name);
        if (builder != null) {
            return builder.create(returnExpression, arguments);
        }
        return new OlapDrillthroughUnknownFunctionReturn(returnExpression, arguments);
    }

    public abstract String getName();

    @Override
    public void setup(OlapEvaluationContext context) {
        this.assertArgumentCount(context);
        if (this.attributeInstr == null) {
            throw new CdShouldNotBeHereProgrammingException("internal error: unexpected missing attribute instruction!");
        }
        OlapEntity attribute = this.attributeInstr.execute(context);
        if (!(attribute instanceof OlapDimension)) {
            String mdx = this.myReturnExpression.getFirstArgumentMdx();
            if (mdx == null) {
                mdx = this.myReturnExpression.asMdx();
            }
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_FUNCTION_DIM_ARGUMENT_TYPE_MISMATCH, new Serializable[]{mdx});
        }
        this.dimension = (OlapDimension)attribute;
        this.setup(context, this.dimension);
    }

    protected void assertArgumentCount(OlapEvaluationContext context) {
        if (this.arguments.size() != 1) {
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_UNEXPECTED_FUNCTION_ARGUMENT_COUNT, Integer.valueOf(this.arguments.size()), Integer.valueOf(1));
        }
    }

    protected void setup(OlapEvaluationContext context, OlapDimension dimension) {
    }

    private static void registerBuilder(Class<? extends OlapDrillthroughReturn> clazz) {
        try {
            Field nameField = clazz.getDeclaredField("NAME");
            String name = (String)nameField.get(null);
            Constructor<? extends OlapDrillthroughReturn> constructor = clazz.getDeclaredConstructor(MdxDrillthroughFunctionReturnExpression.class, List.class);
            ReturnBuilder builder = new ReturnBuilder(clazz, constructor);
            builders.put(name, builder);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new CdProgrammingException("internal error: class [" + clazz.getName() + "]!", (Throwable)ex);
        }
    }

    static {
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughRowIdReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughPartitionIdReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCellReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCalcMemberReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCalcMemberNameReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCalcMemberUniqueNameReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCalcMemberTupleReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughCalcMemberInstrReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughNameFunctionReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughUniqueNameFunctionReturn.class);
        OlapDrillthroughFunctionReturn.registerBuilder(OlapDrillthroughKeyFunctionReturn.class);
    }

    private static class ReturnBuilder {
        private final Class<? extends OlapDrillthroughReturn> clazz;
        private final Constructor<? extends OlapDrillthroughReturn> constructor;

        public ReturnBuilder(Class<? extends OlapDrillthroughReturn> clazz, Constructor<? extends OlapDrillthroughReturn> constructor) {
            this.clazz = clazz;
            this.constructor = constructor;
        }

        public OlapDrillthroughFunctionReturn create(MdxDrillthroughFunctionReturnExpression returnExpression, List<OlapInstr> arguments) {
            try {
                return (OlapDrillthroughFunctionReturn)this.constructor.newInstance(returnExpression, arguments);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new CdProgrammingException("internal error: could not create the class [" + this.clazz.getName() + "]!", (Throwable)ex);
            }
        }
    }
}

