/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.processor;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import java.io.Serializable;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughSingleKeyReturnProcessor
extends OlapDrillthroughReturnProcessor {
    private final boolean forKeyFunction;
    private final OlapDimension dimension;
    private final int keyPart;

    public OlapDrillthroughSingleKeyReturnProcessor(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, boolean forKeyFunction, OlapDimension dimension, int keyPart) {
        super(nameContext, specifiedInRequest, userDefinedName);
        this.forKeyFunction = forKeyFunction;
        this.dimension = dimension;
        this.keyPart = keyPart;
    }

    @Override
    public boolean isForMember() {
        return true;
    }

    @Override
    public boolean isForIndexingDimension(Set<OlapDimension> indexingDimensions) {
        return indexingDimensions.contains(this.dimension);
    }

    @Override
    public OlapDimension getAttachedDimension() {
        return this.dimension;
    }

    @Override
    public String[] getColumnIdentifier() {
        if (this.forKeyFunction) {
            return new String[]{"Key(" + this.dimension.getUniqueName(this.nameContext) + "," + this.keyPart + ")"};
        }
        return new String[]{this.dimension.getUniqueName(this.nameContext) + ".Key" + this.keyPart};
    }

    @Override
    public OlapScalarEntity processIndexColumn(GFContext context, int rowId) {
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public OlapScalarEntity[] processIndexColumn(@Nullable OlapMember member) {
        if (member != null) {
            return new OlapScalarEntity[]{OlapDrillthroughSingleKeyReturnProcessor.processKeyColumnMembers(this.dimension, this.keyPart, member)};
        }
        return EMPTY;
    }

    private static OlapScalarEntity processKeyColumnMembers(OlapDimension dimension, int keyPart, OlapMember member) {
        OlapMemberKey memberKey = member.getKey();
        if (memberKey.isNoValueKey()) {
            return OlapEmptyEntity.INSTANCE;
        }
        int partCount = memberKey.getPartCount();
        if (keyPart >= 0 && keyPart < partCount) {
            return memberKey.asScalarEntity(keyPart);
        }
        throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.DRILLTHROUGH_KEY_PART_INVALID_VALUE, new Serializable[]{ONames.uname4Log(member.getHierarchy()), Integer.valueOf(keyPart), Integer.valueOf(0), Integer.valueOf(partCount)});
    }
}

