/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.processor;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughNameReturnProcessor
extends OlapDrillthroughReturnProcessor {
    private final boolean forNameFunction;
    private final OlapDimension dimension;

    public OlapDrillthroughNameReturnProcessor(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, boolean forNameFunction, OlapDimension dimension) {
        super(nameContext, specifiedInRequest, userDefinedName);
        this.forNameFunction = forNameFunction;
        this.dimension = dimension;
    }

    @Override
    public boolean isForMember() {
        return true;
    }

    @Override
    public boolean isForIndexingDimension(Set<OlapDimension> indexingDimensions) {
        return indexingDimensions.contains(this.dimension);
    }

    @Override
    public OlapDimension getAttachedDimension() {
        return this.dimension;
    }

    @Override
    public String[] getColumnIdentifier() {
        if (this.forNameFunction) {
            return new String[]{"Name(" + this.dimension.getUniqueName(this.nameContext) + ")"};
        }
        return new String[]{this.dimension.getUniqueName(this.nameContext) + ".Name"};
    }

    @Override
    public OlapScalarEntity processIndexColumn(GFContext context, int rowId) {
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public OlapScalarEntity[] processIndexColumn(@Nullable OlapMember member) {
        if (member != null) {
            return new OlapScalarEntity[]{new OlapStringEntity(member.getName(this.nameContext))};
        }
        return EMPTY;
    }
}

