/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.processor;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughMultiKeyReturnProcessor
extends OlapDrillthroughReturnProcessor {
    private final boolean forKeyFunction;
    private final OlapDimension dimension;
    private int maxPartCount = -1;

    public OlapDrillthroughMultiKeyReturnProcessor(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, boolean forKeyFunction, OlapDimension dimension) {
        super(nameContext, specifiedInRequest, userDefinedName);
        this.forKeyFunction = forKeyFunction;
        this.dimension = dimension;
    }

    @Override
    public boolean isForMember() {
        return true;
    }

    @Override
    public boolean isForIndexingDimension(Set<OlapDimension> indexingDimensions) {
        return indexingDimensions.contains(this.dimension);
    }

    @Override
    public OlapDimension getAttachedDimension() {
        return this.dimension;
    }

    @Override
    public String[] getColumnIdentifier() {
        String[] identifiers = this.maxPartCount == -1 ? new String[1] : new String[this.maxPartCount];
        for (int ii = 0; ii < identifiers.length; ++ii) {
            identifiers[ii] = this.forKeyFunction ? "Key(" + this.dimension.getUniqueName(this.nameContext) + "," + ii + ")" : this.dimension.getUniqueName(this.nameContext) + ".Key" + ii;
        }
        return identifiers;
    }

    @Override
    public String[] getColumnIdentifierEx() {
        if (this.userDefinedName == null) {
            return this.getColumnIdentifier();
        }
        String[] identifiers = this.maxPartCount == -1 ? new String[1] : new String[this.maxPartCount];
        for (int ii = 0; ii < identifiers.length; ++ii) {
            identifiers[ii] = this.userDefinedName;
        }
        return identifiers;
    }

    @Override
    public OlapScalarEntity processIndexColumn(GFContext context, int rowId) {
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public OlapScalarEntity[] processIndexColumn(@Nullable OlapMember member) {
        if (member != null) {
            return this.processKeyColumnMembers(this.dimension, member);
        }
        return EMPTY;
    }

    private OlapScalarEntity[] processKeyColumnMembers(OlapDimension dimension, OlapMember member) {
        OlapLevel level;
        OlapBuilderInputType[] keyType;
        OlapMemberKey memberKey = member.getKey();
        int partCount = memberKey.isValueKey() ? memberKey.getPartCount() : ((keyType = (level = member.getLevel()).getMemberKeyType()) != null ? keyType.length : 0);
        OlapScalarEntity[] entities = new OlapScalarEntity[partCount];
        for (int ii = 0; ii < entities.length; ++ii) {
            entities[ii] = memberKey.asScalarEntity(ii);
        }
        this.maxPartCount = Math.max(this.maxPartCount, partCount);
        return entities;
    }
}

