/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactPartitionForDrillthrough;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectorLogic;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMeasureReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughPartitionIdReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughRowIdReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughIdentifierReturn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSingleMeasureDrillthroughCollectorLogic
extends OlapDrillthroughCollectorLogic {
    public OlapSingleMeasureDrillthroughCollectorLogic(OlapSelectStatementExecutionContext executionContext, int maxRowCount, List<OlapDrillthroughReturn> requestedReturns) {
        super(executionContext, maxRowCount, requestedReturns, new OlapDrillthroughCollectorLogic.FactsColumn());
    }

    @Override
    public void doOnCellsEvaluationStarted(@Nullable GFContext context, @Nullable IOlapFactPartitionForDrillthrough partition, @Nullable OlapScalarEntityFactColumn column) {
        if (column == null) {
            throw new RuntimeException("internal error: inconsistent drillthrough processing");
        }
        String measureName = column.getId().getColumnName();
        List<OlapDimension> indexingDimensions = this.getIndexingDimensions(column);
        List<OlapMeasureMember> measures = this.getMeasures(column);
        ArrayList returnProcessors = new ArrayList();
        if (!this.requestedReturns.isEmpty()) {
            for (OlapDrillthroughReturn requestedReturn : this.requestedReturns) {
                List<OlapDrillthroughReturnProcessor> processors = requestedReturn.createProcessors(this.nameContext);
                ArrayList<OlapDrillthroughReturnProcessor> mProcessors = null;
                for (OlapDrillthroughReturnProcessor processor : processors) {
                    OlapDimension pDimension = processor.getAttachedDimension();
                    if (pDimension != null && pDimension.isMeasures()) {
                        mProcessors = new ArrayList<OlapDrillthroughReturnProcessor>();
                        for (OlapMeasureMember measure : measures) {
                            mProcessors.addAll(OlapDrillthroughIdentifierReturn.createProcessors(this.nameContext, true, null, measure));
                        }
                        break;
                    }
                    if (pDimension != null && !indexingDimensions.contains(pDimension)) {
                        throw new OlapEvaluationException(requestedReturn.getLocationRange(), OlapErrorCode.DRILLTHROUGH_DIM_NOT_LINKED_TO_MEASURE, new Serializable[]{ONames.name4Log(pDimension), measureName});
                    }
                    OlapMeasureMember pMeasure = processor.getAttachedMeasure();
                    if (pMeasure != null && !measures.contains(pMeasure)) {
                        throw new OlapEvaluationException(requestedReturn.getLocationRange(), OlapErrorCode.DRILLTHROUGH_MEASURE_NOT_LINKED_TO_MEASURE, new Serializable[]{pMeasure.getName(OlapNameContext.DEFAULT_VALUES), measureName});
                    }
                    if (processor.isForCalcMember()) {
                        throw new OlapEvaluationException(requestedReturn.getLocationRange(), OlapErrorCode.DRILLTHROUGH_SINGLE_CELL_WITH_CALC_MEMBER, new Serializable[0]);
                    }
                    if (!processor.isForCell()) continue;
                    throw new OlapEvaluationException(requestedReturn.getLocationRange(), OlapErrorCode.DRILLTHROUGH_SINGLE_CELL_WITH_CELL, new Serializable[0]);
                }
                if (mProcessors != null) {
                    returnProcessors.addAll(mProcessors);
                    continue;
                }
                returnProcessors.addAll(processors);
            }
        } else {
            returnProcessors.add(new OlapDrillthroughRowIdReturnProcessor(this.nameContext, false, null));
            for (OlapDimension dimension : indexingDimensions) {
                returnProcessors.addAll(OlapDrillthroughIdentifierReturn.createProcessors(this.nameContext, false, null, dimension));
            }
            for (OlapMeasureMember measure : measures) {
                returnProcessors.add(new OlapDrillthroughMeasureReturnProcessor(this.nameContext, false, null, measure));
            }
        }
        for (OlapDrillthroughReturnProcessor returnProcessor : returnProcessors) {
            if (returnProcessor instanceof OlapDrillthroughPartitionIdReturnProcessor) {
                OlapDrillthroughCollectorLogic.PartitionColumn pColumn = new OlapDrillthroughCollectorLogic.PartitionColumn((OlapDrillthroughPartitionIdReturnProcessor)returnProcessor);
                this.collectedColumns.add(pColumn);
                continue;
            }
            if (returnProcessor instanceof OlapDrillthroughMeasureReturnProcessor) {
                OlapDrillthroughCollectorLogic.MeasureColumn mColumn = new OlapDrillthroughCollectorLogic.MeasureColumn((OlapDrillthroughMeasureReturnProcessor)returnProcessor);
                this.collectedMeasureColumns.add(mColumn);
                this.collectedColumns.add(mColumn);
                continue;
            }
            OlapDrillthroughCollectorLogic.IndexColumn iColumn = new OlapDrillthroughCollectorLogic.IndexColumn(returnProcessor);
            this.collectedIndexColumns.add(iColumn);
            this.collectedColumns.add(iColumn);
        }
    }

    @Override
    protected void doOnCellsEvaluationDone() {
    }

    private List<OlapDimension> getIndexingDimensions(OlapScalarEntityFactColumn measureColumn) {
        String measure = measureColumn.getId().getColumnName();
        Collection<OlapDimension> measureGroupDimensions = this.cube.getIndexingDimensions(measure);
        ArrayList<OlapDimension> indexingDimensions = new ArrayList<OlapDimension>();
        if (measureGroupDimensions != null) {
            for (OlapDimension dimension : measureGroupDimensions) {
                if (dimension.isMeasures() || !dimension.isFactIndexing() || !this.permissions.isDimensionAuthorized(dimension)) continue;
                indexingDimensions.add(dimension);
            }
        }
        return indexingDimensions;
    }

    private List<OlapMeasureMember> getMeasures(OlapScalarEntityFactColumn measureColumn) {
        String columnName = measureColumn.getId().getColumnName();
        OlapMeasuresDimension measuresDimension = this.cube.getMeasuresDimension();
        List<OlapMeasureMember> measures = measuresDimension.getMeasureMembers(this.permissions.getMemberFilter());
        OlapMeasureMember columnMeasure = null;
        for (OlapMeasureMember measure : measures) {
            if (!measure.getName(OlapNameContext.DEFAULT_VALUES).equals(columnName)) continue;
            columnMeasure = measure;
        }
        ArrayList<OlapMeasureMember> requestedMeasures = new ArrayList<OlapMeasureMember>();
        if (columnMeasure != null) {
            for (OlapMeasureMember measure : measures) {
                if (!measure.getMeasureGroup().equals(columnMeasure.getMeasureGroup())) continue;
                requestedMeasures.add(measure);
            }
        }
        return requestedMeasures;
    }

    @Override
    protected void setupMeasuresInfo(List<OlapDrillthroughCollectorLogic.CRow> collectedRows) {
        for (OlapDrillthroughCollectorLogic.MeasureColumn collectedMeasureColumn : this.collectedMeasureColumns) {
            this.setupMeasuresInfo(collectedRows, collectedMeasureColumn);
        }
    }

    private void setupMeasuresInfo(List<OlapDrillthroughCollectorLogic.CRow> collectedRows, OlapDrillthroughCollectorLogic.MeasureColumn headerMeasureColumn) {
        OlapMeasureMember measure = headerMeasureColumn.getMeasure();
        for (OlapDrillthroughCollectorLogic.CRow collectedRow : collectedRows) {
            int collectedRowIndex = collectedRow.collectedRowIndex;
            IOlapFactPartitionForDrillthrough partition = this.collectedFactsColumn.partitions.get(collectedRowIndex);
            OlapScalarEntityFactColumn column = partition.dt_getFactColumn(measure);
            if (column != null) {
                OlapScalarEntity value;
                int rowId = this.collectedFactsColumn.rowIds.getInt(collectedRowIndex);
                collectedRow.entities[headerMeasureColumn.getRowPos()] = value = column.getValuedForDrillthrough(rowId);
                continue;
            }
            collectedRow.entities[headerMeasureColumn.getRowPos()] = OlapEmptyEntity.INSTANCE;
        }
    }
}

