/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactPartitionForDrillthrough;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectorLogic;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughCellReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMeasureReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughPartitionIdReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughRowIdReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughCalcMemberReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughIdentifierReturn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapMultiMeasuresDrillthroughCollectorLogic
extends OlapDrillthroughCollectorLogic {
    public OlapMultiMeasuresDrillthroughCollectorLogic(OlapSelectStatementExecutionContext executionContext, int maxRowCount, List<OlapDrillthroughReturn> requestedReturns) {
        super(executionContext, maxRowCount, requestedReturns, new FactsColumnEx());
    }

    @Override
    protected void doOnCellsEvaluationStarted(@Nullable GFContext context, @Nullable IOlapFactPartitionForDrillthrough partition, @Nullable OlapScalarEntityFactColumn column) {
        ArrayList<OlapDrillthroughReturnProcessor> returnProcessors = new ArrayList<OlapDrillthroughReturnProcessor>();
        if (!this.requestedReturns.isEmpty()) {
            for (Object requestedReturn : this.requestedReturns) {
                List<OlapDrillthroughReturnProcessor> processors = ((OlapDrillthroughReturn)requestedReturn).createProcessors(this.nameContext);
                for (OlapDrillthroughReturnProcessor processor : processors) {
                    OlapDimension pDimension = processor.getAttachedDimension();
                    if (pDimension != null && pDimension.isMeasures()) {
                        throw new OlapEvaluationException(((OlapDrillthroughReturn)requestedReturn).getLocationRange(), OlapErrorCode.DRILLTHROUGH_MULTI_CELL_WITH_MEASURES, new Serializable[0]);
                    }
                    OlapMeasureMember pMeasure = processor.getAttachedMeasure();
                    if (pMeasure == null) continue;
                    throw new OlapEvaluationException(((OlapDrillthroughReturn)requestedReturn).getLocationRange(), OlapErrorCode.DRILLTHROUGH_MULTI_CELL_WITH_MEASURE, new Serializable[0]);
                }
                returnProcessors.addAll(processors);
            }
        } else {
            returnProcessors.add(new OlapDrillthroughRowIdReturnProcessor(this.nameContext, false, null));
            returnProcessors.add(new OlapDrillthroughCellReturnProcessor(this.nameContext, false, null));
            returnProcessors.addAll(OlapDrillthroughCalcMemberReturn.createProcessors(this.nameContext, false, null));
            List<OlapDimension> cubeDimensions = this.cube.getOwnDimensions(this.permissions);
            for (OlapDimension dimension : cubeDimensions) {
                if (dimension.isMeasures() || !dimension.isFactIndexing()) continue;
                returnProcessors.addAll(OlapDrillthroughIdentifierReturn.createProcessors(this.nameContext, false, null, dimension));
            }
        }
        for (OlapDrillthroughReturnProcessor returnProcessor : returnProcessors) {
            if (returnProcessor instanceof OlapDrillthroughPartitionIdReturnProcessor) {
                OlapDrillthroughCollectorLogic.PartitionColumn pColumn = new OlapDrillthroughCollectorLogic.PartitionColumn((OlapDrillthroughPartitionIdReturnProcessor)returnProcessor);
                this.collectedColumns.add(pColumn);
                continue;
            }
            OlapDrillthroughCollectorLogic.IndexColumn iColumn = new OlapDrillthroughCollectorLogic.IndexColumn(returnProcessor);
            this.collectedIndexColumns.add(iColumn);
            this.collectedColumns.add(iColumn);
        }
    }

    @Override
    protected void doOnCellsEvaluationDone() {
        this.setupCollectedColumns();
    }

    private void setupCollectedColumns() {
        List<OlapMeasureMember> collectedMeasures = this.setupCollectedMeasures();
        Set<OlapDimension> indexingDimensions = this.setupIndexingDimensions(collectedMeasures);
        ArrayList<OlapDrillthroughCollectorLogic.IndexColumn> columnToDelete = new ArrayList<OlapDrillthroughCollectorLogic.IndexColumn>();
        for (OlapDrillthroughCollectorLogic.IndexColumn collectedIndexColumn : this.collectedIndexColumns) {
            boolean keep;
            OlapDrillthroughReturnProcessor processor = collectedIndexColumn.processor;
            boolean bl = keep = processor.isSpecifiedInRequest() || processor.isRowId() || processor.isForCell() && this.cellTuples.size() > 1 || processor.isForCalcMember() && this.hasCollectedCalcMember || processor.isForIndexingDimension(indexingDimensions);
            if (!keep) {
                columnToDelete.add(collectedIndexColumn);
                continue;
            }
            OlapDimension dimension = processor.getAttachedDimension();
            if (dimension == null || this.permissions.isDimensionAuthorized(dimension)) continue;
            columnToDelete.add(collectedIndexColumn);
        }
        for (OlapDrillthroughCollectorLogic.IndexColumn toDelete : columnToDelete) {
            this.collectedIndexColumns.remove(toDelete);
            this.collectedColumns.remove(toDelete);
        }
        for (OlapMeasureMember measure : collectedMeasures) {
            OlapDrillthroughCollectorLogic.MeasureColumn mColumn = new OlapDrillthroughCollectorLogic.MeasureColumn(new OlapDrillthroughMeasureReturnProcessor(this.nameContext, false, null, measure));
            this.collectedMeasureColumns.add(mColumn);
            this.collectedColumns.add(mColumn);
        }
    }

    private List<OlapMeasureMember> setupCollectedMeasures() {
        LinkedHashSet<String> collectedMeasureNames = new LinkedHashSet<String>();
        for (OlapScalarEntityFactColumn factColumn : ((FactsColumnEx)this.collectedFactsColumn).columns) {
            collectedMeasureNames.add(factColumn.getId().getColumnName());
        }
        OlapMeasuresDimension measuresDimension = this.cube.getMeasuresDimension();
        List<OlapMeasureMember> measures = measuresDimension.getMeasureMembers(this.permissions.getMemberFilter());
        ArrayList<OlapMeasureMember> collectedMeasures = new ArrayList<OlapMeasureMember>();
        for (String measureName : collectedMeasureNames) {
            for (OlapMeasureMember measure : measures) {
                if (!measure.getName(OlapNameContext.DEFAULT_VALUES).equals(measureName)) continue;
                collectedMeasures.add(measure);
            }
        }
        return collectedMeasures;
    }

    private Set<OlapDimension> setupIndexingDimensions(List<OlapMeasureMember> measures) {
        HashSet<OlapDimension> indexingDimensions = new HashSet<OlapDimension>();
        for (OlapMeasureMember measure : measures) {
            Collection<OlapDimension> dimensions = this.cube.getIndexingDimensions(measure.getName(OlapNameContext.DEFAULT_VALUES));
            if (dimensions == null) {
                throw new CdProgrammingException("internal error: inconsistent cube/measure [" + ONames.name4Log(this.cube) + "/" + String.valueOf(measure) + "]!");
            }
            indexingDimensions.addAll(dimensions);
        }
        return indexingDimensions;
    }

    @Override
    protected void setupMeasuresInfo(List<OlapDrillthroughCollectorLogic.CRow> collectedRows) {
        for (OlapDrillthroughCollectorLogic.CRow collectedRow : collectedRows) {
            int collectedRowIndex = collectedRow.collectedRowIndex;
            OlapScalarEntityFactColumn column = ((FactsColumnEx)this.collectedFactsColumn).columns.get(collectedRowIndex);
            for (OlapDrillthroughCollectorLogic.MeasureColumn collectedMeasureColumn : this.collectedMeasureColumns) {
                String columnName;
                String measureName = collectedMeasureColumn.getMeasure().getName(OlapNameContext.DEFAULT_VALUES);
                if (measureName.equals(columnName = column.getId().getColumnName())) {
                    OlapScalarEntity value;
                    int rowId = this.collectedFactsColumn.rowIds.getInt(collectedRowIndex);
                    collectedRow.entities[collectedMeasureColumn.getRowPos()] = value = column.getValuedForDrillthrough(rowId);
                    continue;
                }
                collectedRow.entities[collectedMeasureColumn.getRowPos()] = OlapEmptyEntity.INSTANCE;
            }
        }
    }

    static class FactsColumnEx
    extends OlapDrillthroughCollectorLogic.FactsColumn {
        final List<OlapScalarEntityFactColumn> columns = new ArrayList<OlapScalarEntityFactColumn>();

        FactsColumnEx() {
        }

        @Override
        public void add(IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column, int rowId) {
            super.add(partition, column, rowId);
            this.columns.add(column);
        }
    }
}

