/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactPartitionForDrillthrough;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionHeader;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectorLogic;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.OlapMultiMeasuresDrillthroughCollectorLogic;
import crazydev.iccube.olap.goodies.drillthrough.OlapSingleMeasureDrillthroughCollectorLogic;
import java.util.Collections;
import java.util.List;

public class OlapDrillthroughCollector {
    private final Object globalLOCK = new Object();
    private final OlapSelectStatementExecutionContext executionContext;
    private final int maxRowCount;
    private final List<OlapDrillthroughReturn> requestedReturns;
    private OlapDrillthroughCollectorLogic collectorLogic;
    private boolean multiCellEvaluation;
    private boolean firstCollection;

    public OlapDrillthroughCollector(OlapSelectStatementExecutionContext executionContext, int maxRowCount, List<OlapDrillthroughReturn> requestedReturns) {
        this.executionContext = executionContext;
        this.maxRowCount = maxRowCount;
        this.requestedReturns = requestedReturns;
        this.multiCellEvaluation = false;
        this.firstCollection = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDrillthroughCollection getCollection() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.collectorLogic == null) {
                OlapDrillthroughCollectionHeader header = new OlapDrillthroughCollectionHeader(List.of());
                return new OlapDrillthroughCollection(this.executionContext, this.maxRowCount, header, Collections.emptyList(), 0);
            }
            return this.collectorLogic.getCollection();
        }
    }

    public void onCellsEvaluationStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMultiCellsEvaluationStarted() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.multiCellEvaluation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCellsEvaluationDone() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.collectorLogic != null) {
                this.collectorLogic.onCellsEvaluationDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRange(GFContext context, IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column, int startRowId, int endRowId) {
        if (!context.isCellEvaluation()) {
            throw new CdProgrammingException("internal error: drillthrough outside cell-evaluation!");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.firstCollection) {
                this.setupCollectorLogic(context, partition, column);
                this.firstCollection = false;
            }
            this.collectorLogic.collectRange(context, partition, column, startRowId, endRowId);
        }
    }

    private void setupCollectorLogic(GFContext context, IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column) {
        boolean isCalcMember = context.getCurrentCalcMemberForDrillthrough() != null;
        this.collectorLogic = this.multiCellEvaluation || isCalcMember ? new OlapMultiMeasuresDrillthroughCollectorLogic(this.executionContext, this.maxRowCount, this.requestedReturns) : new OlapSingleMeasureDrillthroughCollectorLogic(this.executionContext, this.maxRowCount, this.requestedReturns);
        this.collectorLogic.onCellsEvaluationStarted(context, partition, column);
    }
}

