/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCalcMemberNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OlapMdxDebugPerfNode
extends OlapMdxDebugNode {
    private long totalTime = 0L;
    private OlapCalculatedMember calcMember;
    private int count = 0;

    public OlapMdxDebugPerfNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent) {
        super(collector, parent, 0L, 0L);
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return this.calcMember.getUniqueName(nameContext);
    }

    @Override
    public String getExecTimeMillisAsString() {
        return null;
    }

    public void addPerfNode(OlapMdxDebugCalcMemberNode calcMemberNode) {
        this.totalTime += calcMemberNode.getExecTimeMillis();
        this.calcMember = calcMemberNode.getCalculatedMember();
        ++this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public List<OlapMdxDebugNode.Info> getInfos() {
        return Arrays.asList(new OlapMdxDebugNode.Info("Exec. Time ", CdTimeUtils.formatMillis((long)this.totalTime)), new OlapMdxDebugNode.Info("Exec. Time (Avg)", CdTimeUtils.formatNanos((long)(TimeUnit.MILLISECONDS.toNanos(this.totalTime) / (long)this.count))), new OlapMdxDebugNode.Info("Count", Integer.toString(this.count)));
    }
}

