/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugAxesNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugInstrPrepareNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNodeNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugOnDemandNodes;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugPreparedNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugNode {
    protected final OlapMdxDebugNodeCollector collector;
    private final List<Info> infos = new ArrayList<Info>();
    protected long startTime;
    @Nullable
    protected OlapMdxDebugNode parent;
    @Nullable
    protected List<OlapMdxDebugNode> children;
    protected long endTime;
    private boolean evalCached;
    private boolean rangeInvalid;
    private List<OlapMember> defaultMembers;
    @Nullable
    private String fastCrossjoinNonEmptyBehavior;

    public OlapMdxDebugNode(OlapMdxDebugNodeCollector collector, @Nullable OlapMdxDebugNode parent) {
        this(collector, parent, -1L, -1L);
    }

    public OlapMdxDebugNode(OlapMdxDebugNodeCollector collector, @Nullable OlapMdxDebugNode parent, long startTime, long endTime) {
        this.collector = collector;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.startTime = startTime == -1L ? System.currentTimeMillis() : startTime;
        this.endTime = endTime;
        this.collector.incrementNodeCount();
    }

    protected OlapMdxDebugNode(OlapMdxDebugNodeCollector collector, @Nullable OlapMdxDebugNode parent, @Nullable List<OlapMember> defaultMembers, long startTime, long endTime) {
        this.collector = collector;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.startTime = startTime == -1L ? System.currentTimeMillis() : startTime;
        this.endTime = endTime;
        this.defaultMembers = defaultMembers;
        this.collector.incrementNodeCount();
    }

    public boolean isScript() {
        return false;
    }

    public boolean isWith() {
        return false;
    }

    public boolean isAxes() {
        return false;
    }

    public boolean isAxis() {
        return false;
    }

    public boolean isSlicer() {
        return false;
    }

    public boolean isSubSelect() {
        return false;
    }

    public boolean isCells() {
        return false;
    }

    public boolean isTupleNode() {
        return false;
    }

    public boolean isOnDemand() {
        return false;
    }

    public void onFastCrossjoinNonEmptyBehavior(String nonEmptyBehavior) {
        this.fastCrossjoinNonEmptyBehavior = this.fastCrossjoinNonEmptyBehavior == null ? nonEmptyBehavior : this.fastCrossjoinNonEmptyBehavior + "\n" + nonEmptyBehavior;
    }

    @Nullable
    public String getFastCrossjoinNonEmptyBehavior() {
        return this.fastCrossjoinNonEmptyBehavior;
    }

    public void onDefaultMember(OlapMember member) {
        if (this.defaultMembers == null) {
            this.defaultMembers = new ArrayList<OlapMember>();
        }
        this.defaultMembers.add(member);
    }

    public List<OlapMember> getDefaultMembers() {
        return this.defaultMembers;
    }

    public void onCachedTupleValue(boolean cached) {
        this.evalCached = cached;
    }

    public boolean isEvalCached() {
        return this.evalCached;
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public int indexOfChild(OlapMdxDebugNode child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public void addChild(OlapMdxDebugNode child) {
        if (this.children == null) {
            this.children = new ArrayList<OlapMdxDebugNode>();
        }
        this.children.add(child);
    }

    public void addChild(int pos, OlapMdxDebugNode child) {
        if (this.children == null) {
            throw new CdProgrammingException("inconsistent call: no children");
        }
        this.children.add(pos, child);
    }

    public void removeChild(OlapMdxDebugNode child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public OlapMdxDebugNode getChild(int index) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("empty-" + index);
        }
        return this.children.get(index);
    }

    public void sortChildren(Comparator<OlapMdxDebugNode> comparator) {
        if (this.children != null) {
            Collections.sort(this.children, comparator);
        }
    }

    public void adoptChildren(OlapMdxDebugNode from) {
        int fromChildrenCount = from.getChildrenCount();
        for (int idx = 0; idx < fromChildrenCount; ++idx) {
            OlapMdxDebugNode fromChild = from.getChild(idx);
            fromChild.parent = this;
            this.addChild(fromChild);
        }
        from.clearChildren();
    }

    public void moveToNode(OlapMdxDebugNode node) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = node;
        this.parent.addChild(this);
    }

    public void moveLast() {
        OlapMdxDebugNode myParent = this.parent;
        if (myParent != null) {
            myParent.removeChild(this);
            myParent.addChild(this);
        }
    }

    public void moveBefore(OlapMdxDebugNode node) {
        OlapMdxDebugNode myParent = this.parent;
        if (myParent != null) {
            myParent.removeChild(this);
            int pos = myParent.indexOfChild(node);
            if (pos != -1) {
                myParent.addChild(pos, this);
            }
        }
    }

    @Nullable
    public OlapMdxDebugNode getParent() {
        return this.parent;
    }

    public void setAsOrphan() {
        this.parent = null;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public List<OlapMdxDebugNode> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getTitle(OlapNameContext nameContext) {
        return "?";
    }

    public String getFormula() {
        return "";
    }

    @Nullable
    public String getTuple(OlapNameContext nameContext) {
        return null;
    }

    @Nullable
    public final Range getRange() {
        if (this.rangeInvalid) {
            return null;
        }
        return this.doGetRange();
    }

    protected Range doGetRange() {
        return null;
    }

    protected void invalidateRangeR() {
        this.rangeInvalid = true;
        if (this.children != null) {
            for (OlapMdxDebugNode child : this.children) {
                child.invalidateRangeR();
            }
        }
    }

    public int getDepth() {
        return this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getExecTimeMillis() {
        return this.endTime - this.startTime;
    }

    public long getExecTimeMillisFromChildren() {
        long ms = 0L;
        if (this.children != null) {
            for (OlapMdxDebugNode child : this.children) {
                ms += child.getExecTimeMillis();
            }
        }
        return ms;
    }

    public void onEnd() {
        this.setEndTime();
    }

    public void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public void fixTupleNodes() {
        if (this.children != null) {
            for (OlapMdxDebugNode child : this.children) {
                child.fixTupleNodes();
            }
            if (!this.isAxis() && !this.isSlicer()) {
                ArrayList<OlapMdxDebugNode> toRemove = new ArrayList<OlapMdxDebugNode>();
                for (OlapMdxDebugNode child : this.children) {
                    if (!child.isTupleNode() || child.getChildrenCount() != 0) continue;
                    toRemove.add(child);
                }
                for (OlapMdxDebugNode node : toRemove) {
                    node.remove();
                }
            }
        }
    }

    public void fixPreparedAxisNodes() {
        if (this.children != null) {
            ArrayList<OlapMdxDebugInstrPrepareNode> pNodes = new ArrayList<OlapMdxDebugInstrPrepareNode>();
            for (OlapMdxDebugNode child : this.children) {
                if (!(child instanceof OlapMdxDebugAxesNode)) continue;
                OlapMdxDebugAxesNode axes = (OlapMdxDebugAxesNode)child;
                for (OlapMdxDebugNode axesChild : axes.children) {
                    if (!(axesChild instanceof OlapMdxDebugInstrPrepareNode)) continue;
                    pNodes.add((OlapMdxDebugInstrPrepareNode)axesChild);
                }
            }
            if (!pNodes.isEmpty()) {
                OlapMdxDebugPreparedNodes preparedNodes = new OlapMdxDebugPreparedNodes(this.collector, this);
                for (OlapMdxDebugInstrPrepareNode pNode : pNodes) {
                    pNode.remove();
                    preparedNodes.addChild(pNode);
                }
            }
        }
    }

    public void fixOnDemandNodes() {
        ArrayList<OlapMdxDebugNode> onDemandNodes = new ArrayList<OlapMdxDebugNode>();
        this.findOnDemandNodes(onDemandNodes);
        if (!onDemandNodes.isEmpty()) {
            OlapMdxDebugOnDemandNodes onDemandNode = new OlapMdxDebugOnDemandNodes(this.collector, this);
            for (OlapMdxDebugNode node : onDemandNodes) {
                OlapMdxDebugNode nodeParent = node.getParent();
                if (nodeParent instanceof OlapMdxDebugInstrPrepareNode) {
                    OlapMdxDebugNode parentX = ((OlapMdxDebugInstrPrepareNode)nodeParent).forkForOnDemandFix();
                    node.remove();
                    parentX.addChild(node);
                    onDemandNode.addChild(parentX);
                    continue;
                }
                node.remove();
                onDemandNode.addChild(node);
            }
        }
    }

    private void findOnDemandNodes(List<OlapMdxDebugNode> onDemandNodes) {
        if (this.children != null) {
            for (OlapMdxDebugNode child : this.children) {
                if (child.isOnDemand()) {
                    onDemandNodes.add(child);
                    break;
                }
                child.findOnDemandNodes(onDemandNodes);
            }
        }
    }

    protected String asReturnType(@Nullable OlapScalarEntity value) {
        return value == null ? "<null>" : value.getXmlaType(null).toString();
    }

    protected String asReturnValue(@Nullable OlapEntity value) {
        return value == null ? "<null>" : value.toString();
    }

    protected String asReturnValueExtraInfo(@Nullable OlapEntity value) {
        return "";
    }

    protected String asReturnType(@Nullable OlapEntity value) {
        return value == null ? "<null>" : value.getFriendlyTypeName();
    }

    protected String asReturnValue(OlapNameContext nameContext, @Nullable OlapEntity entity) {
        if (entity == null) {
            return "<null>";
        }
        if (entity instanceof OlapCalculatedMember) {
            OlapCalculatedMember calculatedMember = (OlapCalculatedMember)entity;
            return calculatedMember.getFormula().toStringForDebugger();
        }
        return entity.toStringForDebuggerAsValue();
    }

    protected String asReturnValueExtraInfo(OlapNameContext nameContext, OlapEntity entity) {
        if (entity instanceof OlapTupleSet) {
            OlapTupleSet set = (OlapTupleSet)entity;
            return "size:" + set._sizeSlow();
        }
        return "";
    }

    protected String asReturnType(Throwable exception) {
        return exception.getClass().getSimpleName();
    }

    protected String asReturnValue(Throwable exception) {
        return exception.getMessage();
    }

    public String getReturnType() {
        return "";
    }

    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        return "";
    }

    @Nullable
    private List<OlapMember> getDefaultMembersR() {
        if (this.defaultMembers != null && !this.defaultMembers.isEmpty()) {
            return this.defaultMembers;
        }
        if (this.parent != null) {
            return this.parent.getDefaultMembersR();
        }
        return null;
    }

    public String getDefaultMembers(OlapNameContext nameContext) {
        List<OlapMember> members = this.getDefaultMembersR();
        if (members != null && !members.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (OlapMember defaultMember : members) {
                String name = defaultMember.getUniqueName(nameContext);
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(name);
            }
            return sb.toString();
        }
        return "";
    }

    public String getReturnValue(OlapNameContext nameContext) {
        return "";
    }

    public String getArgumentInfo(OlapNameContext nameContext) {
        return "";
    }

    public void addStats(OlapMdxStatementEvalStatistics stats) {
        this.infos.add(new Info("tuple-aggregate", String.valueOf(stats.tupleAggregateCount())));
        this.infos.add(new Info("tuple-aggregate-set", String.valueOf(stats.tupleAggregateSetCount())));
        this.infos.add(new Info("set-evaluator", String.valueOf(stats.setEvaluatorCount())));
    }

    public List<Info> getInfos() {
        return this.infos;
    }

    public String toString() {
        return this.getTitle(null);
    }

    public void visitNodes(Predicate<OlapMdxDebugNode> visitor) {
        if (visitor.test(this) && this.children != null) {
            this.children.forEach(child -> child.visitNodes(visitor));
        }
    }

    @Nullable
    public OlapMdxDebugNode lookupNode(GFNode iNode) {
        if (this.children != null) {
            for (OlapMdxDebugNode child : this.children) {
                OlapMdxDebugNode node;
                if (child instanceof OlapMdxDebugNodeNode && (node = (OlapMdxDebugNodeNode)child).isMatchingNode(iNode)) {
                    return node;
                }
                node = child.lookupNode(iNode);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public String getExecTimeMillisAsString() {
        return CdTimeUtils.formatMillis((long)this.getExecTimeMillis());
    }

    public static class Range {
        public final String mdxHash;
        public final int from;
        public final int to;
        public final int lineNumber;

        public Range(String mdxHash, int from, int to, int lineNumber) {
            this.mdxHash = mdxHash;
            this.from = from;
            this.to = to;
            this.lineNumber = lineNumber;
        }
    }

    public static class Info {
        public final String name;
        public final String value;

        public Info(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

