/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSubSubSelectInstr;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugInstrPrepareNode
extends OlapMdxDebugNode {
    private final OlapInstr instr;
    @Nullable
    private RuntimeException exception;

    public OlapMdxDebugInstrPrepareNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parentNode, OlapInstr instr) {
        super(collector, parentNode);
        this.instr = instr;
    }

    public OlapMdxDebugNode forkForOnDemandFix() {
        OlapMdxDebugInstrPrepareNode fork = new OlapMdxDebugInstrPrepareNode(this.collector, null, this.instr);
        fork.startTime = this.startTime;
        fork.endTime = this.endTime;
        return fork;
    }

    @Override
    public boolean isScript() {
        return this.instr instanceof OlapScriptInstr;
    }

    @Override
    public boolean isSubSelect() {
        return this.instr instanceof OlapSubSelectInstr || this.instr instanceof OlapSubSubSelectInstr;
    }

    public void addResult(OlapPreparedInstr result) {
    }

    public void addError(RuntimeException exception) {
        this.exception = exception;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        if (this.exception == null && (this.children == null || this.children.isEmpty()) && this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return this.instr.toStringForDebugger();
    }

    @Override
    protected OlapMdxDebugNode.Range doGetRange() {
        OlapInstrLocationRange instrRange = this.instr.getLocationRange();
        return new OlapMdxDebugNode.Range(instrRange.mdxHash(), instrRange.from(), instrRange.to(), instrRange.lineNumber());
    }

    @Override
    public String getReturnType() {
        if (this.exception != null) {
            return this.asReturnType(this.exception);
        }
        return "";
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        return "";
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        if (this.exception != null) {
            return this.asReturnValue(this.exception);
        }
        return "";
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return "";
    }

    public boolean matchInstr(OlapInstr instr) {
        return this.instr == instr;
    }
}

