/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugCellNode
extends OlapMdxDebugNode {
    private final OlapTuple[] cellTuples;
    private final OlapTuple tuple;
    private final OlapResCell cell;
    private final int column;
    private final String columnInfo;

    public OlapMdxDebugCellNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent, long startTime, long endTime, int[] Si, OlapTuple[] cellTuples, OlapTuple tuple, @Nullable List<OlapMember> defaultMembers, OlapResCell cell) {
        super(collector, parent, defaultMembers, startTime, endTime);
        OlapTuple cellTuple;
        this.cellTuples = cellTuples;
        this.tuple = tuple;
        this.cell = cell;
        this.column = Si[0];
        StringBuilder ci = new StringBuilder();
        if (cellTuples.length > 0 && (cellTuple = cellTuples[0]).getMemberCount() > 0) {
            ci.append(" ( ");
            for (int ii = 0; ii < cellTuple.getMemberCount(); ++ii) {
                if (ii > 0) {
                    ci.append(", ");
                }
                OlapMember member = cellTuple.getMember(ii);
                ci.append(member.getNameX());
            }
            ci.append(" ) ");
        }
        this.columnInfo = ci.toString();
    }

    public OlapTuple[] getCellTuples() {
        return this.cellTuples;
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return "Columns-" + this.column + this.columnInfo;
    }

    @Override
    public String getTuple(OlapNameContext nameContext) {
        return this.tuple.toMdxString(nameContext, true, 512);
    }

    public OlapResCell getCell() {
        return this.cell;
    }

    @Override
    public String getReturnType() {
        OlapScalarEntity value = this.cell.getRequestPropertyValue(OlapIntrinsicCellProperties.VALUE);
        return this.asReturnType(value);
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        return "ordinal:" + this.cell.getOrdinal();
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        OlapScalarEntity value = this.cell.getRequestPropertyValue(OlapIntrinsicCellProperties.VALUE);
        return this.asReturnValue(nameContext, value);
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return "";
    }
}

