/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugCalcMemberNode
extends OlapMdxDebugNode {
    private final OlapCalculatedMember calculatedMember;
    @Nullable
    private OlapScalarEntity value;
    @Nullable
    private Throwable exception;

    public OlapMdxDebugCalcMemberNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent, OlapCalculatedMember calculatedMember) {
        super(collector, parent);
        this.calculatedMember = calculatedMember;
    }

    @Override
    public void onEnd() {
        if (!this.calculatedMember.isDefinedAtSelectStatementLevel()) {
            this.invalidateRangeR();
        }
        super.onEnd();
    }

    @Override
    public String getFormula() {
        if (!this.calculatedMember.isDefinedAtSelectStatementLevel()) {
            return this.calculatedMember.getFormula().getMdx();
        }
        return "";
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return "Calc. Member : " + this.calculatedMember.getUniqueName(nameContext);
    }

    @Override
    protected OlapMdxDebugNode.Range doGetRange() {
        OlapInstrLocationRange idRange = this.calculatedMember.getIdRange();
        return new OlapMdxDebugNode.Range(idRange.mdxHash(), idRange.from(), idRange.to(), idRange.lineNumber());
    }

    @Override
    public String getReturnType() {
        if (this.exception != null) {
            return this.asReturnType(this.exception);
        }
        return this.asReturnType(this.value);
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        return "SOLVE_ORDER:" + this.calculatedMember.getSolveOrder();
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        if (this.exception != null) {
            return this.asReturnValue(this.exception);
        }
        return this.asReturnValue(nameContext, this.value);
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return this.calculatedMember.getUniqueName(nameContext);
    }

    public void setValue(OlapScalarEntity value) {
        this.value = value.asConstant();
    }

    public void setError(Throwable exception) {
        this.exception = exception;
    }

    public OlapCalculatedMember getCalculatedMember() {
        return this.calculatedMember;
    }
}

