/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.codecompletion;

import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapCodeCompletionSuggestion {
    private final Set<OlapMember> members = new HashSet<OlapMember>();
    private final String completion;
    private final String caption;

    public OlapCodeCompletionSuggestion(String completion) {
        this(completion, completion);
    }

    public OlapCodeCompletionSuggestion(String completion, String caption) {
        this(null, completion, caption);
    }

    public OlapCodeCompletionSuggestion(@Nullable OlapMember member, String completion, String caption) {
        if (member != null) {
            this.members.add(member);
        }
        this.completion = completion;
        this.caption = caption;
    }

    public boolean hasMember() {
        return !this.members.isEmpty();
    }

    public void mergeMembers(OlapCodeCompletionSuggestion other) {
        this.members.addAll(other.members);
    }

    public String getCompletion() {
        return this.completion;
    }

    public String getCaption() {
        if (this.members.size() > 1) {
            return this.caption + " *" + this.members.size() + "*";
        }
        return this.caption;
    }

    public String toString() {
        return this.completion + " : " + this.caption;
    }
}

