/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.codecompletion;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.mdx.scanner.CdMdxScanner;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxKeywordToken;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotationType;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.command.OlapExecCommandRepository;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilterHelper;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorRepository;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionContextInfo;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionSuggestion;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapNameIdentifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class OlapCodeCompletion {
    private static final List<String> allCellProperties = OlapCodeCompletion.allCellProperties();
    private static CdRuntimeException sizeExceededMarker = new CdRuntimeException("sizeExceededMarker");
    private final int maxNumSuggestions;
    private final OlapCodeCompletionContextInfo contextInfo;
    @Nullable
    private final IOlapSchemaPermission schemaPermissions;
    private final String mdx;
    private final int offset;
    private final List<OlapCodeCompletionSuggestion> suggestions = new ArrayList<OlapCodeCompletionSuggestion>();
    private final Set<String> suggestionsC = new HashSet<String>();
    @Nullable
    private final OlapSchema schema;
    private List<CdMdxToken> tokens;
    private CdMdxTokenKind tokenKindToComplete;
    private String tokenLexemeToComplete;
    private List<CdMdxToken> tokens_;
    private int currentTokenIndex_;

    private OlapCodeCompletion(OlapRolePermissions permissions, int maxNumSuggestions, OlapCodeCompletionContextInfo contextInfo, String mdx, int offset) {
        this.maxNumSuggestions = maxNumSuggestions;
        this.mdx = mdx;
        this.offset = offset;
        this.contextInfo = contextInfo;
        this.schema = contextInfo.getSchema();
        IOlapSchemasPermission schemasPermissions = permissions.getSchemasPermissions();
        this.schemaPermissions = this.schema == null ? null : schemasPermissions.getSchemaPermissions(contextInfo.getContext(), this.schema, true);
    }

    private static List<String> allCellProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (OlapCellProperty property : OlapCellPropertyManager.getAllProperties()) {
            names.add(property.getName());
        }
        names.add("AGGREGATION");
        names.add("ASSOCIATED_MEASURE_GROUP");
        names.add("CAPTION");
        names.add("DISPLAY_FOLDER");
        names.add("EMPTY_IS_ZERO");
        names.add("NON_EMPTY_BEHAVIOR");
        names.add("REQUEST_CACHED");
        names.add("SCOPE_ISOLATION");
        names.add("SOLVE_ORDER");
        names.add("VISIBLE");
        return names;
    }

    public static List<OlapCodeCompletionSuggestion> getSuggestions(OlapRolePermissions permissions, OlapRequestNamesContext nameContext, int maxNumSuggestions, OlapCodeCompletionContextInfo contextInfo, String mdx, int offset) {
        OlapCodeCompletion instance;
        block24: {
            if (contextInfo == null) {
                return new ArrayList<OlapCodeCompletionSuggestion>();
            }
            if (CdStringUtils.isNullOrBlank((String)mdx)) {
                if (contextInfo.isCellProperties()) {
                    return OlapCodeCompletion.completeAllCellProperties();
                }
                return new ArrayList<OlapCodeCompletionSuggestion>();
            }
            OlapSchema requestedSchema = contextInfo.getSchema();
            if (requestedSchema != null) {
                OlapRoleApplicationPermissions applicationPermissions = permissions.getApplicationPermissions();
                IOlapSchemasPermission schemasPermissions = permissions.getSchemasPermissions();
                boolean isSchemaAuthorized = schemasPermissions.isSchemaAuthorized(applicationPermissions, requestedSchema);
                if (!isSchemaAuthorized) {
                    contextInfo = contextInfo.notAuthorized();
                }
            }
            instance = new OlapCodeCompletion(permissions, maxNumSuggestions, contextInfo, mdx, offset);
            try {
                if (instance.setup()) {
                    if (instance.isMdxEntity() && !contextInfo.isEmpty()) {
                        instance.completeMdxEntity(nameContext);
                    } else if (instance.isTidyPostProcessorName()) {
                        instance.completeTidyPostProcessorName();
                    } else if (instance.isExecCommand()) {
                        instance.completeExecCommand();
                    } else if (instance.isOthers()) {
                        instance.completeOthers();
                    } else if (instance.isForCellProperties()) {
                        instance.completeForCellProperties();
                    } else if (contextInfo.getEmptyToken() != null && instance.isVoidTokenKindToComplete()) {
                        instance.completeOnEmptyToken(nameContext, contextInfo);
                    } else if (contextInfo.isCellProperties()) {
                        instance.completeCellProperties();
                    }
                } else if (contextInfo.getEmptyToken() != null && instance.isVoidTokenKindToComplete()) {
                    instance.completeOnEmptyToken(nameContext, contextInfo);
                } else {
                    instance.completeOnScanError(nameContext);
                }
            }
            catch (CdRuntimeException ex) {
                if (ex == sizeExceededMarker) break block24;
                throw ex;
            }
        }
        return instance.suggestions;
    }

    private static IOlapDimensionsPermission getDimensionPermissions(IOlapSchemaPermission schemaPermissions, @Nullable OlapCube olapCube) {
        return schemaPermissions.getDimensionsPermissions(olapCube);
    }

    private static IOlapHierarchyPermission getHierarchyPermissions(IOlapSchemaPermission schemaPermissions, @Nullable OlapCube cube, OlapHierarchy hierarchy) {
        IOlapDimensionsPermission permissions = OlapCodeCompletion.getDimensionPermissions(schemaPermissions, cube);
        IOlapDimensionPermission dimensionPermissions = permissions.getDimensionPermissions(hierarchy.getDimension());
        return dimensionPermissions.getHierarchyPermission(hierarchy);
    }

    private boolean isVoidTokenKindToComplete() {
        return this.tokenKindToComplete == null || this.tokenKindToComplete == CdMdxTokenKind.WHITE_SPACES || this.tokenKindToComplete == CdMdxTokenKind.EOL;
    }

    private boolean setup() {
        if (this.offset < 0 || this.offset > this.mdx.length()) {
            return false;
        }
        String mdxToScan = this.mdx.substring(0, this.offset);
        if (mdxToScan.trim().length() == 0) {
            return false;
        }
        try {
            this.tokens = new CdMdxScanner().scan(true, mdxToScan, "code-completion");
            this.tokens_ = new ArrayList<CdMdxToken>(this.tokens);
            if (this.tokens.isEmpty()) {
                return false;
            }
            CdMdxToken lastToken = this.tokens.get(this.tokens.size() - 1);
            if (lastToken.getKind() == CdMdxTokenKind.DOT) {
                this.tokenKindToComplete = CdMdxTokenKind.DELIMITED_IDENTIFIER;
                this.tokenLexemeToComplete = "";
                return true;
            }
            this.tokenKindToComplete = lastToken.getKind();
            this.tokenLexemeToComplete = lastToken.getLexeme();
            this.tokens.remove(this.tokens.size() - 1);
            return true;
        }
        catch (CdMdxScannerException ex) {
            if (ex.getOffset() != this.offset - 1) {
                return false;
            }
            this.tokens = ex.getTokens();
            this.tokenKindToComplete = ex.getTokenKind();
            this.tokenLexemeToComplete = this.tokens.isEmpty() ? this.mdx.substring(0, ex.getOffset() + 1) : this.mdx.substring(this.tokens.get(this.tokens.size() - 1).getEndOffset(), ex.getOffset() + 1);
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private boolean isMdxEntity() {
        return this.tokenKindToComplete == CdMdxTokenKind.DELIMITED_IDENTIFIER || this.tokenKindToComplete == CdMdxTokenKind.DOT && this.isBeforeLastVisibleToken(CdMdxTokenKind.DELIMITED_IDENTIFIER);
    }

    private boolean isTidyPostProcessorName() {
        return (this.tokenKindToComplete == CdMdxTokenKind.WHITE_SPACES || this.tokenKindToComplete == CdMdxTokenKind.REGULAR_IDENTIFIER) && (this.lookBehindKind(0) == CdMdxTokenKind.TIDYPOSTPROCESSOR || this.lookBehindKind(0) == CdMdxTokenKind.ADD_TO_RESULT && this.lookBehindKind(1) == CdMdxTokenKind.TIDYPOSTPROCESSOR);
    }

    @Nullable
    private CdMdxTokenKind lookBehindKind(int pos) {
        int count = 0;
        for (int idx = this.tokens.size() - 1; idx >= 0; --idx) {
            CdMdxToken token = this.tokens.get(idx);
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) continue;
            if (count == pos) {
                return token.getKind();
            }
            ++count;
        }
        return null;
    }

    private boolean isExecCommand() {
        return this.isAfterExec();
    }

    private boolean isOthers() {
        return this.tokenKindToComplete == CdMdxTokenKind.REGULAR_IDENTIFIER || this.tokenKindToComplete == CdMdxTokenKind.ANNOTATION || CdMdxTokenKind.isKeyword((CdMdxTokenKind)this.tokenKindToComplete);
    }

    private boolean isBeforeLastVisibleToken(CdMdxTokenKind kind) {
        for (int idx = this.tokens.size() - 1; idx >= 0; --idx) {
            CdMdxToken token = this.tokens.get(idx);
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) continue;
            return kind.equals((Object)token.getKind());
        }
        return false;
    }

    private static List<OlapCodeCompletionSuggestion> completeAllCellProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (String property : allCellProperties) {
            names.add(property.toUpperCase());
        }
        names.sort(String::compareTo);
        names.remove("FORMAT_STRING");
        names.remove("SOLVE_ORDER");
        names.remove("CELL_ORDINAL");
        names.remove("UPDATEABLE");
        names.add(0, "FORMAT_STRING");
        names.add(1, "SOLVE_ORDER");
        ArrayList<OlapCodeCompletionSuggestion> suggestions = new ArrayList<OlapCodeCompletionSuggestion>();
        for (String name : names) {
            suggestions.add(new OlapCodeCompletionSuggestion(name));
        }
        return suggestions;
    }

    private void completeOnEmptyToken(OlapRequestNamesContext nameContext, OlapCodeCompletionContextInfo contextInfo) {
        this.tokenLexemeToComplete = "";
        String emptyToken = contextInfo.getEmptyToken();
        if (!"measures".equals(emptyToken)) {
            return;
        }
        OlapCube cube = contextInfo.getCube();
        if (cube != null) {
            this.completeMeasures(nameContext, cube, cube.getMeasuresDimension());
        }
    }

    private void completeOnScanError(OlapRequestNamesContext nameContext) {
        this.tokens = new ArrayList<CdMdxToken>();
        this.tokenKindToComplete = null;
        this.tokenLexemeToComplete = "";
        for (int pos = Math.max(0, this.offset - 1); pos >= 0; --pos) {
            char cc = this.mdx.charAt(pos);
            if (cc == '[') {
                this.tokenKindToComplete = CdMdxTokenKind.DELIMITED_IDENTIFIER;
                this.tokenLexemeToComplete = this.mdx.substring(pos, this.offset);
                break;
            }
            if (!CdMdxScanner.isSeparator((int)cc)) continue;
            this.tokenKindToComplete = CdMdxTokenKind.REGULAR_IDENTIFIER;
            if (this.offset < pos + 1) break;
            this.tokenLexemeToComplete = this.mdx.substring(pos + 1, this.offset);
            break;
        }
        if (this.isMdxEntity() && !this.contextInfo.isEmpty()) {
            this.completeMdxEntity(nameContext);
        } else if (this.isTidyPostProcessorName()) {
            this.completeTidyPostProcessorName();
        } else if (this.isExecCommand()) {
            this.completeExecCommand();
        } else if (this.isOthers()) {
            this.completeOthers();
        } else if (this.contextInfo.getEmptyToken() != null && this.isVoidTokenKindToComplete()) {
            this.completeOnEmptyToken(nameContext, this.contextInfo);
        }
    }

    private void completeCellProperties() {
        if (this.tokens_ == null) {
            return;
        }
        if (this.tokens_.isEmpty()) {
            this.suggestions.addAll(OlapCodeCompletion.completeAllCellProperties());
            return;
        }
        this.startParseTokenB();
        if (this.parseTokenB(CdMdxTokenKind.COMMA) != null) {
            this.suggestions.addAll(OlapCodeCompletion.completeAllCellProperties());
            return;
        }
        this.startParseTokenB();
        if (this.parseTokenB(CdMdxTokenKind.EQ) != null) {
            CdMdxToken cellProperty = this.parseTokenB(CdMdxTokenKind.REGULAR_IDENTIFIER);
            if (cellProperty != null && cellProperty.getLexeme().equalsIgnoreCase("FORMAT_STRING")) {
                this.completeCellPropertyValues_FORMAT_STRING(null);
            }
            return;
        }
        this.startParseTokenB();
        if (this.parseStringTokenB("'") != null) {
            CdMdxToken cellProperty;
            CdMdxToken eq = this.parseTokenB(CdMdxTokenKind.EQ);
            if (eq != null && (cellProperty = this.parseTokenB(CdMdxTokenKind.REGULAR_IDENTIFIER)) != null && cellProperty.getLexeme().equalsIgnoreCase("FORMAT_STRING")) {
                this.completeCellPropertyValues_FORMAT_STRING("'");
            }
            return;
        }
        this.startParseTokenB();
        if (this.parseStringTokenB("\"") != null) {
            CdMdxToken cellProperty;
            CdMdxToken eq = this.parseTokenB(CdMdxTokenKind.EQ);
            if (eq != null && (cellProperty = this.parseTokenB(CdMdxTokenKind.REGULAR_IDENTIFIER)) != null && cellProperty.getLexeme().equalsIgnoreCase("FORMAT_STRING")) {
                this.completeCellPropertyValues_FORMAT_STRING("\"");
            }
            return;
        }
    }

    private void completeCellPropertyValues_FORMAT_STRING(@Nullable String prefix) {
        this.completeCellPropertyValue_FORMAT_STRING(prefix, "Standard");
        this.completeCellPropertyValue_FORMAT_STRING(prefix, "Currency");
        this.completeCellPropertyValue_FORMAT_STRING(prefix, "Percent");
        this.completeCellPropertyValue_FORMAT_STRING(prefix, "Scientific");
        this.completeCellPropertyValue_FORMAT_STRING(prefix, "Fixed");
    }

    private void completeCellPropertyValue_FORMAT_STRING(@Nullable String prefix, String value) {
        if (prefix == null) {
            this.addSuggestion(new OlapCodeCompletionSuggestion("\"" + value + "\""));
        } else if (prefix.equals("'")) {
            this.addSuggestion(new OlapCodeCompletionSuggestion(value + "'", value));
        } else if (prefix.equals("\"")) {
            this.addSuggestion(new OlapCodeCompletionSuggestion(value + "\"", value));
        }
    }

    private void startParseTokenB() {
        this.currentTokenIndex_ = this.tokens_ != null ? this.tokens_.size() - 1 : -1;
    }

    @Nullable
    private CdMdxToken parseTokenB(CdMdxTokenKind tokenKind) {
        CdMdxToken token = this.parseTokenB();
        if (token != null && token.getKind() == tokenKind) {
            return token;
        }
        return null;
    }

    @Nullable
    private CdMdxToken parseStringTokenB(String lexeme) {
        CdMdxToken token = this.parseTokenB();
        if (token != null && token.getKind() == CdMdxTokenKind.STRING && token.getLexeme().equals(lexeme)) {
            return token;
        }
        return null;
    }

    @Nullable
    private CdMdxToken parseTokenB() {
        CdMdxToken token;
        while ((token = this.doParseTokenB()) != null && CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) {
        }
        return token;
    }

    @Nullable
    private CdMdxToken doParseTokenB() {
        CdMdxToken token = null;
        if (this.currentTokenIndex_ >= 0) {
            token = this.tokens_.get(this.currentTokenIndex_--);
        }
        return token;
    }

    private void completeOthers() {
        if (this.tokenLexemeToComplete.startsWith("//#")) {
            for (MdxAnnotationType annotation : MdxAnnotationType.values()) {
                this.addOthersCompletionIfMatching("//#" + annotation.name());
            }
            return;
        }
        if (this.tokenLexemeToComplete.startsWith("#")) {
            for (MdxAnnotationType annotation : MdxAnnotationType.values()) {
                this.addOthersCompletionIfMatching("#" + annotation.name());
            }
            return;
        }
        OlapSchema schema = this.contextInfo.getSchema();
        OlapSchemaFunctionRepository functionRepository = schema == null ? new OlapSchemaFunctionRepository(new OlapFunctionRepository()) : schema.getFunctionRepository();
        for (String functionName : functionRepository.getAllFunctionNames()) {
            this.addOthersCompletionIfMatching(functionName);
        }
        for (String property : allCellProperties) {
            this.addOthersCompletionIfMatching(property);
        }
        Iterable<String> intrinsicMemberProperties = OlapIntrinsicMemberProperties.getAllNames();
        for (String intrinsicMemberProperty : intrinsicMemberProperties) {
            this.addOthersCompletionIfMatching(intrinsicMemberProperty);
        }
        if (this.isBeforeLastVisibleToken(CdMdxTokenKind.DOT)) {
            return;
        }
        for (CdMdxTokenKind keyword : CdMdxKeywordToken.getKeywords()) {
            this.addOthersCompletionIfMatching(keyword.name());
        }
    }

    private void completeMdxEntity(OlapRequestNamesContext nameContext) {
        OlapSchema schema = this.contextInfo.getSchema();
        if (schema == null) {
            return;
        }
        if (this.schemaPermissions == null) {
            return;
        }
        if (this.isBeforeLastVisibleToken(CdMdxTokenKind.FROM)) {
            this.completeSchemaForCubes(nameContext);
        } else if (this.isBeforeLastVisibleToken(CdMdxTokenKind.DOT)) {
            OlapEntityIdentifier entityIdentifier = this.getRootIdentifier();
            OlapNonScalarEntity entity = null;
            if (entityIdentifier != null) {
                IOlapDimensionsPermission dimensionsPermission;
                OlapCube cube;
                List<OlapCube> schemaCubes = schema.getCubes(this.schemaPermissions);
                Collection<OlapCube> filteredSchemaCubes = this.filterCubes(schemaCubes);
                Iterator<OlapCube> iterator = filteredSchemaCubes.iterator();
                while (iterator.hasNext()) {
                    cube = iterator.next();
                    entity = cube.lookupEntityByMdxIdentifier(nameContext, dimensionsPermission = OlapCodeCompletion.getDimensionPermissions(this.schemaPermissions, cube), null, null, entityIdentifier);
                    if (entity.isMdxNull()) continue;
                    if (entity instanceof OlapMeasuresDimension) {
                        this.completeMeasures(nameContext, cube, (OlapMeasuresDimension)entity);
                        continue;
                    }
                    if (entity instanceof OlapHierarchy && ((OlapHierarchy)entity).getDimension().isMeasures()) {
                        this.completeHierarchy(nameContext, this.schemaPermissions, cube, (OlapHierarchy)entity);
                        continue;
                    }
                    if (entity instanceof OlapLevel && ((OlapLevel)entity).getDimension().isMeasures()) {
                        this.completeLevel(nameContext, cube, (OlapLevel)entity);
                        continue;
                    }
                    if (!(entity instanceof OlapMember) || !((OlapMember)entity).getDimension().isMeasures()) continue;
                    this.completeChildren(nameContext, cube, (OlapMember)entity);
                }
                if (this.suggestions.isEmpty() && (iterator = filteredSchemaCubes.iterator()).hasNext() && !(entity = (cube = iterator.next()).lookupEntityByMdxIdentifier(nameContext, dimensionsPermission = OlapCodeCompletion.getDimensionPermissions(this.schemaPermissions, cube), null, null, entityIdentifier)).isMdxNull()) {
                    if (entity instanceof OlapDimension) {
                        this.completeDimension(nameContext, this.schemaPermissions, cube, (OlapDimension)entity);
                    } else if (entity instanceof OlapHierarchy) {
                        this.completeHierarchy(nameContext, this.schemaPermissions, cube, (OlapHierarchy)entity);
                    } else if (entity instanceof OlapLevel) {
                        this.completeLevel(nameContext, cube, (OlapLevel)entity);
                    } else if (entity instanceof OlapMember) {
                        this.completeChildren(nameContext, cube, (OlapMember)entity);
                    }
                }
            }
        } else {
            this.completeSchemaForDimensions(nameContext);
        }
    }

    @Nullable
    private OlapEntityIdentifier getRootIdentifier() {
        ArrayList<CdMdxIdentifierToken> identifiers = new ArrayList<CdMdxIdentifierToken>();
        MutableInt pos = new MutableInt(this.tokens.size() - 1);
        CdMdxToken token = this.parseToken(pos);
        if (token == null) {
            return null;
        }
        if (token.getKind() == CdMdxTokenKind.DOT && (token = this.parseToken(pos)) == null) {
            return null;
        }
        while (token != null && token.getKind() == CdMdxTokenKind.DELIMITED_IDENTIFIER) {
            identifiers.add(0, (CdMdxIdentifierToken)((CdMdxDelimitedIdentifierToken)token));
            token = this.parseToken(pos);
            if (token == null || token.getKind() != CdMdxTokenKind.DOT) break;
            token = this.parseToken(pos);
        }
        if (identifiers.isEmpty()) {
            return null;
        }
        return MdxEntityCompiler.createOlapIdentifier(new MdxIdentifierExpression(identifiers));
    }

    @Nullable
    private CdMdxToken parseToken(MutableInt pos) {
        CdMdxToken token;
        while ((token = this.doParseToken(pos)) != null && CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) {
        }
        return token;
    }

    @Nullable
    private CdMdxToken doParseToken(MutableInt pos) {
        CdMdxToken token = null;
        if (pos.intValue() >= 0) {
            token = this.tokens.get(pos.intValue());
            pos.decrement();
        }
        return token;
    }

    private void completeSchemaForDimensions(OlapRequestNamesContext nameContext) {
        List<OlapHierarchy> allHierarchies;
        String caption;
        String completion;
        String addIn;
        OlapSchema schema = this.contextInfo.getSchema();
        if (schema == null) {
            return;
        }
        if (this.schemaPermissions == null) {
            return;
        }
        boolean dimensionOnly = true;
        IOlapDimensionsPermission dimensionsPermission = OlapCodeCompletion.getDimensionPermissions(this.schemaPermissions, null);
        for (OlapDimension dimension : this.filterDimension(schema.getDimensions(dimensionsPermission))) {
            if (!this.addMdxEntityCompletionIfMatching(dimension.getName(nameContext)) || this.tokenLexemeToComplete.trim().equals("[")) continue;
            OlapCodeCompletionSuggestion suggestion = (OlapCodeCompletionSuggestion)CdCollections.last(this.suggestions);
            for (OlapHierarchy hierarchy : this.filterHierarchies(dimension.getHierarchies(dimensionsPermission))) {
                if (suggestion == null) continue;
                String hierarchyAddIn = ".[" + hierarchy.getName(nameContext) + "]";
                String completion2 = suggestion.getCompletion() + hierarchyAddIn;
                String caption2 = suggestion.getCaption() + hierarchyAddIn;
                this.addSuggestion(completion2, caption2);
                dimensionOnly = false;
            }
        }
        if (this.contextInfo.getHierarchy() != null) {
            return;
        }
        if (dimensionOnly && !this.suggestions.isEmpty()) {
            Iterator<OlapNameIdentifiable> iterator = this.filterCubes(schema.getCubes(this.schemaPermissions)).iterator();
            if (iterator.hasNext()) {
                OlapCube cube = (OlapCube)iterator.next();
                OlapMeasuresDimension measures = cube.getMeasuresDimension();
                this.addMdxEntityCompletionIfMatching(measures.getName(nameContext));
            }
        } else if (this.suggestions.isEmpty()) {
            HashMap<String, OlapCodeCompletionSuggestion> measuresSuggestions = new HashMap<String, OlapCodeCompletionSuggestion>();
            Collection<OlapCube> cubes = this.filterCubes(schema.getCubes(this.schemaPermissions));
            for (OlapCube cube : cubes) {
                IOlapDimensionsPermission perms = OlapCodeCompletion.getDimensionPermissions(this.schemaPermissions, cube);
                OlapNameContext nc = this.getNameContext(nameContext, cube);
                OlapMeasuresDimension measures = cube.getMeasuresDimension();
                String measuresName = measures.getName(nc);
                if (!this.addMdxEntityCompletionIfMatching(measuresName)) continue;
                OlapCodeCompletionSuggestion ms = (OlapCodeCompletionSuggestion)measuresSuggestions.get(measuresName);
                if (ms == null) {
                    ms = (OlapCodeCompletionSuggestion)CdCollections.last(this.suggestions);
                    measuresSuggestions.put(measuresName, ms);
                }
                if (ms == null) continue;
                OlapMemberFilter filter = perms == null ? null : perms.getMemberFilter();
                List<OlapMeasureMember> members = this.filterMeasureGroups(measures.getMeasureMembers(filter));
                for (OlapMeasureMember olapMeasureMember : members) {
                    addIn = ".[" + olapMeasureMember.getName(nc) + "]";
                    completion = ms.getCompletion() + addIn;
                    caption = ms.getCaption() + addIn;
                    this.addSuggestion(completion, caption);
                }
                List<OlapMember> calcMeasures = this.fixCalcMeasures(cube);
                for (OlapMember calcMember : calcMeasures) {
                    if (!calcMember.isMeasure()) continue;
                    String addIn2 = ".[" + calcMember.getName(nc) + "]";
                    String completion3 = ms.getCompletion() + addIn2;
                    String caption3 = ms.getCaption() + addIn2;
                    this.addSuggestion(completion3, caption3);
                }
            }
        }
        if (this.suggestions.isEmpty() && dimensionsPermission != null) {
            for (OlapDimension dimension : this.filterDimension(schema.getDimensions(dimensionsPermission))) {
                allHierarchies = this.filterHierarchies(dimension.getHierarchies(dimensionsPermission));
                for (OlapHierarchy hierarchy : allHierarchies) {
                    if (this.addMdxEntityCompletionIfMatching(hierarchy.getName(nameContext)) && this.tokenLexemeToComplete.trim().equals("[")) continue;
                    OlapCodeCompletionSuggestion suggestion = (OlapCodeCompletionSuggestion)CdCollections.last(this.suggestions);
                    IOlapHierarchyPermission hierarchyPermissions = OlapCodeCompletion.getHierarchyPermissions(this.schemaPermissions, null, hierarchy);
                    for (OlapLevel level : hierarchy.getLevels(hierarchyPermissions)) {
                        if (suggestion == null) continue;
                        String addIn3 = ".[" + level.getName(nameContext) + "]";
                        String completion4 = suggestion.getCompletion() + addIn3;
                        String caption4 = suggestion.getCaption() + addIn3;
                        this.addSuggestion(completion4, caption4);
                    }
                }
            }
        }
        if (this.suggestions.isEmpty() && dimensionsPermission != null) {
            for (OlapDimension dimension : this.filterDimension(schema.getDimensions(dimensionsPermission))) {
                allHierarchies = this.filterHierarchies(dimension.getHierarchies(dimensionsPermission));
                for (OlapHierarchy hierarchy : allHierarchies) {
                    IOlapHierarchyPermission hierarchyPermissions = OlapCodeCompletion.getHierarchyPermissions(this.schemaPermissions, null, hierarchy);
                    for (final OlapLevel level : hierarchy.getLevels(hierarchyPermissions)) {
                        OlapMember member;
                        if (!this.addMdxEntityCompletionIfMatching(level.getName(nameContext))) continue;
                        OlapCodeCompletionSuggestion suggestion = (OlapCodeCompletionSuggestion)CdCollections.last(this.suggestions);
                        if (this.tokenLexemeToComplete.trim().equals("[")) continue;
                        OlapIterator members = level.getMembers(this.getTupleFilter(null)).getIterator(false);
                        members.reset();
                        while ((member = (OlapMember)members.next()) != null) {
                            if (suggestion == null) continue;
                            String addIn4 = ".[" + member.getName(nameContext) + "]";
                            String string = suggestion.getCompletion() + addIn4;
                            String caption5 = suggestion.getCaption() + addIn4;
                            this.addSuggestion(member, string, caption5);
                        }
                        List<OlapMember> allCalcMembers = this.getCalculatedMembers(null);
                        ArrayList calcMembers = CdCollections.filter(allCalcMembers, (CdFilter)new CdFilter<OlapMember>(){
                            {
                                Objects.requireNonNull(this$0);
                            }

                            public boolean accept(OlapMember calcMember) {
                                return calcMember.getLevel().equals(level) && !calcMember.isMeasure();
                            }
                        });
                        if (calcMembers == null) continue;
                        for (OlapMember olapMember : calcMembers) {
                            if (suggestion == null) continue;
                            addIn = ".[" + olapMember.getName(nameContext) + "]";
                            completion = suggestion.getCompletion() + addIn;
                            caption = suggestion.getCaption() + addIn;
                            this.addSuggestion(completion, caption);
                        }
                    }
                }
            }
        }
    }

    private List<OlapMember> fixCalcMeasures(OlapCube cube) {
        if (this.schemaPermissions == null) {
            return Collections.emptyList();
        }
        IOlapDimensionsPermission perms = OlapCodeCompletion.getDimensionPermissions(this.schemaPermissions, cube);
        final OlapMemberFilter filter = perms == null ? null : perms.getMemberFilter();
        OlapSchema schema = cube.getSchema();
        OlapCubeCalculatedMemberManager cubeCalcMemberManager = cube.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = this.contextInfo.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, cubeCalcMemberManager);
        List<OlapMember> calcMembers = calcMemberManager.getVisibleCalculatedMembers(null);
        return CdCollections.filter(calcMembers, (CdFilter)new CdFilter<OlapMember>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapMember member) {
                return member.isMeasure() && OlapMemberFilterHelper.isAccepting(filter, member);
            }
        });
    }

    private void completeSchemaForCubes(OlapNameContext nameContext) {
        OlapSchema schema = this.contextInfo.getSchema();
        if (schema == null) {
            return;
        }
        for (OlapCube cube : this.filterCubes(schema.getCubes(this.schemaPermissions))) {
            this.addMdxEntityCompletionIfMatching(cube.getName(nameContext));
        }
    }

    private void completeMeasures(OlapRequestNamesContext nameContext, OlapCube cube, OlapMeasuresDimension measures) {
        if (this.contextInfo.getHierarchy() != null) {
            return;
        }
        this.completeMeasureLevel(nameContext, cube, measures);
        this.completeCubeCalcMeasures(nameContext, cube);
    }

    private void completeDimension(OlapNameContext nameContext, IOlapSchemaPermission schemaPermissions, OlapCube cube, OlapDimension dimension) {
        HashMap<OlapHierarchy, Integer> hierarchySuggestions = new HashMap<OlapHierarchy, Integer>();
        IOlapDimensionsPermission dimensionsPermission = OlapCodeCompletion.getDimensionPermissions(schemaPermissions, cube);
        List<OlapHierarchy> allHierarchies = this.filterHierarchies(dimension.getHierarchies(dimensionsPermission));
        for (OlapHierarchy hierarchy : allHierarchies) {
            if (!this.addMdxEntityCompletionIfMatching(hierarchy.getName(nameContext))) continue;
            hierarchySuggestions.put(hierarchy, this.suggestions.size() - 1);
        }
        for (OlapHierarchy hierarchy : allHierarchies) {
            Integer suggestionIndex = (Integer)hierarchySuggestions.get(hierarchy);
            if (suggestionIndex == null) continue;
            OlapCodeCompletionSuggestion hierarchySuggestion = this.suggestions.get(suggestionIndex);
            IOlapHierarchyPermission hierarchyPermissions = OlapCodeCompletion.getHierarchyPermissions(schemaPermissions, cube, hierarchy);
            for (OlapLevel level : hierarchy.getLevels(hierarchyPermissions)) {
                String addIn = ".[" + level.getName(nameContext) + "]";
                String completion = hierarchySuggestion.getCompletion() + addIn;
                String caption = hierarchySuggestion.getCaption() + addIn;
                this.addSuggestion(completion, caption);
            }
        }
    }

    private OlapNameContext getNameContext(OlapRequestNamesContext requestNameContext, @Nullable OlapCube cube) {
        if (cube == null || this.schemaPermissions == null) {
            return requestNameContext;
        }
        IOlapDimensionsPermission perms = this.schemaPermissions.getDimensionsPermissions(cube);
        OlapNameContext nameContext = perms.getNamingContext(requestNameContext);
        return nameContext;
    }

    @Nullable
    private OlapMemberFilter getTupleFilter(@Nullable OlapCube cube) {
        if (this.schemaPermissions == null) {
            return null;
        }
        IOlapDimensionsPermission perms = this.schemaPermissions.getDimensionsPermissions(cube);
        OlapMemberFilter filter = perms.getMemberFilter();
        return filter;
    }

    private void completeHierarchy(OlapRequestNamesContext nameContext, IOlapSchemaPermission schemaPermissions, OlapCube cube, OlapHierarchy hierarchy) {
        OlapNameContext nc = this.getNameContext(nameContext, cube);
        int levelDepth = hierarchy.getAllLevel() == null ? 0 : 1;
        IOlapHierarchyPermission hierarchyPermissions = OlapCodeCompletion.getHierarchyPermissions(schemaPermissions, cube, hierarchy);
        for (OlapLevel level : hierarchy.getLevels(hierarchyPermissions)) {
            this.addMdxEntityCompletionIfMatching(level.getName(nc));
            if (this.tokenLexemeToComplete.trim().isEmpty() || level.getDepth() > levelDepth) continue;
            this.completeLevel(nameContext, cube, level);
        }
    }

    private void completeMeasureLevel(OlapRequestNamesContext nameContext, OlapCube cube, OlapMeasuresDimension measures) {
        if (this.schemaPermissions == null) {
            return;
        }
        OlapMemberFilter filter = this.getTupleFilter(cube);
        List<OlapMeasureMember> filteredMeasures = measures.getMeasureMembers(filter);
        OlapNameContext nc = this.getNameContext(nameContext, cube);
        List<OlapMeasureMember> members = this.filterMeasureGroups(filteredMeasures);
        for (OlapMeasureMember member : members) {
            this.addMdxEntityCompletionIfMatching(member.getName(nc));
        }
    }

    private void completeLevel(OlapRequestNamesContext nameContext, OlapCube cube, final OlapLevel level) {
        OlapMember member;
        if (this.schemaPermissions == null) {
            return;
        }
        OlapNameContext nc = this.getNameContext(nameContext, cube);
        OlapIterator members = level.getMembers(this.getTupleFilter(cube)).getIterator(false);
        members.reset();
        while ((member = (OlapMember)members.next()) != null) {
            this.addMdxEntityCompletionIfMatching(member, member.getName(nc));
        }
        List<OlapMember> allCalcMembers = this.getCalculatedMembers(cube);
        ArrayList calcMembers = CdCollections.filter(allCalcMembers, (CdFilter)new CdFilter<OlapMember>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapMember calcMember) {
                return calcMember.getLevel().equals(level) && !calcMember.isMeasure();
            }
        });
        if (calcMembers != null) {
            for (OlapMember calcMember : calcMembers) {
                this.addMdxEntityCompletionIfMatching(calcMember.getName(nc));
            }
        }
    }

    private List<OlapMember> getCalculatedMembers(@Nullable OlapCube cube) {
        if (this.schema == null) {
            return Collections.emptyList();
        }
        OlapMemberFilter filter = this.getTupleFilter(cube);
        OlapSchemaCalculatedMemberManager schemaCalcMemberManager = this.schema.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = this.contextInfo.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(this.schema, schemaCalcMemberManager);
        List<OlapMember> allCalcMembers = calcMemberManager.getVisibleCalculatedMembers(filter);
        return allCalcMembers;
    }

    private void completeCubeCalcMeasures(OlapRequestNamesContext nameContext, OlapCube cube) {
        OlapNameContext nc = this.getNameContext(nameContext, cube);
        for (OlapMember calcMember : this.fixCalcMeasures(cube)) {
            if (!calcMember.isMeasure()) continue;
            this.addMdxEntityCompletionIfMatching(calcMember.getName(nc));
        }
    }

    private void completeChildren(OlapRequestNamesContext nameContext, OlapCube cube, final OlapMember member) {
        OlapMember child;
        if (this.schemaPermissions == null) {
            return;
        }
        OlapNameContext nc = this.getNameContext(nameContext, cube);
        OlapIterator<OlapMember> children = member.getChildren(this.getTupleFilter(cube));
        children.reset();
        while ((child = children.next()) != null) {
            this.addMdxEntityCompletionIfMatching(child, child.getName(nc));
        }
        List<OlapMember> allCalcMembers = this.getCalculatedMembers(cube);
        ArrayList calcMembers = CdCollections.filter(allCalcMembers, (CdFilter)new CdFilter<OlapMember>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapMember calcMember) {
                OlapMember calcMemberParent = calcMember.getParent();
                return calcMemberParent != null && calcMemberParent.equals(member) && !calcMember.isMeasure();
            }
        });
        if (calcMembers != null) {
            for (OlapMember calcMember : calcMembers) {
                this.addMdxEntityCompletionIfMatching(calcMember.getName(nc));
            }
        }
    }

    private boolean addMdxEntityCompletionIfMatching(String mdxEntityName) {
        return this.addMdxEntityCompletionIfMatching(null, mdxEntityName);
    }

    private boolean addMdxEntityCompletionIfMatching(@Nullable OlapMember member, String mdxEntityName) {
        String tokenToCompare = this.tokenLexemeToComplete.replace("[", "");
        if (mdxEntityName.toLowerCase().startsWith(tokenToCompare.toLowerCase())) {
            String caption;
            String completion;
            boolean hasBracket;
            boolean bl = hasBracket = !tokenToCompare.equals(this.tokenLexemeToComplete);
            if (this.tokenLexemeToComplete.isEmpty()) {
                caption = completion = "[" + mdxEntityName.substring(tokenToCompare.length()) + "]";
            } else {
                completion = mdxEntityName.substring(tokenToCompare.length()) + (hasBracket ? "]" : "");
                caption = this.tokenLexemeToComplete + completion;
            }
            this.addSuggestion(member, completion, caption);
            return true;
        }
        return false;
    }

    private boolean addOthersCompletionIfMatching(String name) {
        String prefixLC;
        String nameLC = name.toLowerCase();
        if (nameLC.startsWith(prefixLC = this.tokenLexemeToComplete.toLowerCase())) {
            boolean moreThanOne;
            String addIn = name.substring(this.tokenLexemeToComplete.length());
            boolean allUp = CdStringUtils.isAllLetterUpperCase((String)this.tokenLexemeToComplete);
            boolean allDown = !allUp && CdStringUtils.isAllLetterLowerCase((String)this.tokenLexemeToComplete);
            boolean isToken = CdStringUtils.isAllLetterUpperCase((String)addIn);
            boolean bl = moreThanOne = CdStringUtils.countLetters((String)this.tokenLexemeToComplete) > 1;
            String completion = moreThanOne && allUp ? addIn.toUpperCase() : (moreThanOne && isToken && CdStringUtils.isCamel((String)this.tokenLexemeToComplete) ? CdStringUtils.toCamel((String)addIn, (char)'_') : (isToken && allDown ? addIn.toLowerCase() : addIn));
            String caption = this.tokenLexemeToComplete + completion;
            this.addSuggestion(completion, caption);
            return true;
        }
        return false;
    }

    private void addSuggestion(String completion, String caption) {
        this.addSuggestion(null, completion, caption);
    }

    private void addSuggestion(@Nullable OlapMember member, String completion, String caption) {
        this.addSuggestion(new OlapCodeCompletionSuggestion(member, completion, caption));
    }

    private void addSuggestion(OlapCodeCompletionSuggestion suggestion) {
        if (!this.suggestionsC.contains(suggestion.getCompletion())) {
            this.suggestions.add(suggestion);
            this.suggestionsC.add(suggestion.getCompletion());
            this.assertSuggestionListSize();
        } else if (suggestion.hasMember()) {
            for (OlapCodeCompletionSuggestion s : this.suggestions) {
                if (!suggestion.getCompletion().equals(s.getCompletion())) continue;
                s.mergeMembers(suggestion);
                break;
            }
        }
    }

    private void assertSuggestionListSize() {
        if (this.suggestions.size() >= this.maxNumSuggestions) {
            throw sizeExceededMarker;
        }
    }

    private List<OlapDimension> filterDimension(List<OlapDimension> dimensions) {
        OlapFactMeasureGroupBaseManager factBaseManager;
        OlapDimension contextDimension = this.contextInfo.getDimension();
        if (contextDimension != null) {
            return this.doFilterDimensionForDimension(dimensions, contextDimension);
        }
        OlapCube cube = this.contextInfo.getCube();
        String contextMeasureGroup = this.contextInfo.getMeasureGroupName();
        if (cube != null && contextMeasureGroup != null && (factBaseManager = cube.getCubeFactManager().getFactManager(contextMeasureGroup)) != null) {
            return this.doFilterDimensionForMeasureGroup(dimensions, factBaseManager);
        }
        if (cube != null) {
            return this.doFilterDimensionForCube(dimensions, cube);
        }
        return dimensions;
    }

    private List<OlapDimension> doFilterDimensionForCube(List<OlapDimension> dimensions, OlapCube cube) {
        ArrayList<OlapDimension> filtered = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : dimensions) {
            if (!cube.isOwnDimension(dimension)) continue;
            filtered.add(dimension);
        }
        return filtered;
    }

    private List<OlapDimension> doFilterDimensionForMeasureGroup(List<OlapDimension> dimensions, OlapFactMeasureGroupBaseManager factBaseManager) {
        ArrayList<OlapDimension> filtered = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : dimensions) {
            if (!factBaseManager.containsDimension(dimension)) continue;
            filtered.add(dimension);
        }
        return filtered;
    }

    private List<OlapDimension> doFilterDimensionForDimension(List<OlapDimension> dimensions, OlapDimension contextDimension) {
        ArrayList<OlapDimension> filtered = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : dimensions) {
            if (dimension != contextDimension) continue;
            filtered.add(dimension);
        }
        return filtered;
    }

    private Collection<OlapCube> filterCubes(Collection<OlapCube> cubes) {
        OlapCube context = this.contextInfo.getCube();
        if (context == null) {
            return cubes;
        }
        ArrayList<OlapCube> filtered = new ArrayList<OlapCube>();
        for (OlapCube cube : cubes) {
            if (cube != context) continue;
            filtered.add(cube);
        }
        return filtered;
    }

    private List<OlapHierarchy> filterHierarchies(List<OlapHierarchy> hierarchies) {
        OlapHierarchy context = this.contextInfo.getHierarchy();
        if (context == null) {
            return hierarchies;
        }
        ArrayList<OlapHierarchy> filtered = new ArrayList<OlapHierarchy>();
        for (OlapHierarchy hierarchy : hierarchies) {
            if (hierarchy != context) continue;
            filtered.add(hierarchy);
        }
        return filtered;
    }

    private List<OlapMeasureMember> filterMeasureGroups(List<OlapMeasureMember> measures) {
        String context = this.contextInfo.getMeasureGroupName();
        if (context == null) {
            return measures;
        }
        ArrayList<OlapMeasureMember> filtered = new ArrayList<OlapMeasureMember>();
        for (OlapMeasureMember measure : measures) {
            if (!OlapCaseInsensitiveName.equals(measure.getMeasureGroupName(), context)) continue;
            filtered.add(measure);
        }
        return filtered;
    }

    private boolean isAfterExec() {
        for (int idx = this.tokens.size() - 1; idx >= 0; --idx) {
            CdMdxToken token = this.tokens.get(idx);
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) continue;
            if (CdMdxTokenKind.SEMI_COLON.equals((Object)token.getKind())) {
                return false;
            }
            if (!CdMdxTokenKind.IC3RUN.equals((Object)token.getKind())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private String isAfterExecCommand() {
        String afterExec = null;
        for (int idx = this.tokens.size() - 1; idx >= 0; --idx) {
            CdMdxToken token = this.tokens.get(idx);
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) continue;
            if (CdMdxTokenKind.SEMI_COLON.equals((Object)token.getKind())) {
                return null;
            }
            if (CdMdxTokenKind.IC3RUN.equals((Object)token.getKind())) {
                if (afterExec != null) {
                    return afterExec;
                }
                return null;
            }
            afterExec = token.getLexeme();
        }
        return null;
    }

    private void completeTidyPostProcessorName() {
        boolean afterAddToResult = this.isBeforeLastVisibleToken(CdMdxTokenKind.ADD_TO_RESULT);
        Set<String> names = OlapTidyPostProcessorRepository.INSTANCE.getTidyPostProcessorNames();
        if (this.tokenKindToComplete == CdMdxTokenKind.WHITE_SPACES) {
            if (!afterAddToResult) {
                this.suggestions.add(new OlapCodeCompletionSuggestion("ADD_TO_RESULT"));
            }
            for (String name : names) {
                this.suggestions.add(new OlapCodeCompletionSuggestion(name));
            }
        } else {
            if (!afterAddToResult) {
                this.addOthersCompletionIfMatching("ADD_TO_RESULT");
            }
            for (String name : names) {
                this.addOthersCompletionIfMatching(name);
            }
        }
    }

    private void completeExecCommand() {
        if (this.isBeforeLastVisibleToken(CdMdxTokenKind.IC3RUN)) {
            if (CdStringUtils.isNullOrBlank((String)this.tokenLexemeToComplete)) {
                for (String name : OlapExecCommandRepository.getCommandNames()) {
                    this.addSuggestion(name, name);
                }
            } else {
                for (String name : OlapExecCommandRepository.getCommandNames()) {
                    this.addOthersCompletionIfMatching(name);
                }
            }
            return;
        }
        String afterCommand = this.isAfterExecCommand();
        this.completeExecCommandOptions(afterCommand);
    }

    private void completeExecCommandOptions(@Nullable String afterCommand) {
        block4: {
            if (afterCommand == null) break block4;
            List<String> options = OlapExecCommandRepository.getCommandOptions(afterCommand);
            if (CdStringUtils.isNullOrBlank((String)this.tokenLexemeToComplete)) {
                for (String option : options) {
                    this.addSuggestion(option, option);
                }
            } else {
                for (String option : options) {
                    this.addOthersCompletionIfMatching(option);
                }
            }
        }
    }

    private boolean isForCellProperties() {
        this.startParseTokenB();
        if (this.parseTokenB(CdMdxTokenKind.COMMA) != null) {
            return true;
        }
        this.startParseTokenB();
        if (this.parseTokenB(CdMdxTokenKind.EQ) != null) {
            return true;
        }
        this.startParseTokenB();
        if (this.parseStringTokenB("'") != null) {
            return true;
        }
        this.startParseTokenB();
        return this.parseStringTokenB("\"") != null;
    }

    private void completeForCellProperties() {
        this.completeCellProperties();
    }
}

