/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnWithMeasureGroup;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapFactMemMapListConfiguration {
    private final CdVFileSystem vfs;
    private final OlapFactMeasureColumnWithMeasureGroup columnId;
    private final File dataDirectory;
    private final String columnName;
    @Nullable
    private final String extraColumnName;
    private final boolean distinctCount;
    private final int writeBackId;
    private final int fileBits;
    private final int bufferBits;

    public OlapFactMemMapListConfiguration(CdVFileSystem vfs, OlapFactMeasureColumnWithMeasureGroup columnId, File dataDirectory, String columnName, boolean distinctCount, int fileBits, int bufferBits) {
        this(vfs, columnId, dataDirectory, columnName, null, distinctCount, -1, fileBits, bufferBits);
    }

    protected OlapFactMemMapListConfiguration(CdVFileSystem vfs, OlapFactMeasureColumnWithMeasureGroup columnId, File dataDirectory, String columnName, @Nullable String extraColumnName, boolean distinctCount, int writeBackId, int fileBits, int bufferBits) {
        this.vfs = vfs;
        this.columnId = columnId;
        this.dataDirectory = dataDirectory;
        this.columnName = columnName;
        this.extraColumnName = extraColumnName;
        this.distinctCount = distinctCount;
        this.writeBackId = writeBackId;
        this.fileBits = fileBits;
        this.bufferBits = bufferBits;
    }

    public OlapFactMemMapListConfiguration copyForBooleanNulls() {
        int writeBackId = this.columnId.incrementAndGetWriteBackId();
        return new OlapFactMemMapListConfiguration(this.vfs, this.columnId, this.dataDirectory, this.columnName, "boolean-nulls", this.distinctCount, writeBackId, this.fileBits, this.bufferBits);
    }

    public OlapFactMemMapListConfiguration copyForBooleanValues() {
        int writeBackId = this.columnId.incrementAndGetWriteBackId();
        return new OlapFactMemMapListConfiguration(this.vfs, this.columnId, this.dataDirectory, this.columnName, "boolean-values", this.distinctCount, writeBackId, this.fileBits, this.bufferBits);
    }

    public OlapFactMemMapListConfiguration copyForModifiedUtf8Positions() {
        int writeBackId = this.columnId.incrementAndGetWriteBackId();
        return new OlapFactMemMapListConfiguration(this.vfs, this.columnId, this.dataDirectory, this.columnName, "utf8-positions", this.distinctCount, writeBackId, this.fileBits, this.bufferBits);
    }

    public OlapFactMemMapListConfiguration copyForModifiedUtf8Values() {
        int writeBackId = this.columnId.incrementAndGetWriteBackId();
        return new OlapFactMemMapListConfiguration(this.vfs, this.columnId, this.dataDirectory, this.columnName, "utf8-values", this.distinctCount, writeBackId, this.fileBits, this.bufferBits);
    }

    public OlapFactMemMapListConfiguration copyForExtra(String extra) {
        int writeBackId = this.columnId.incrementAndGetWriteBackId();
        return new OlapFactMemMapListConfiguration(this.vfs, this.columnId, this.dataDirectory, this.columnName, extra, this.distinctCount, writeBackId, this.fileBits, this.bufferBits);
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Nullable
    public String getExtraColumnName() {
        return this.extraColumnName;
    }

    public boolean isDistinctCount() {
        return this.distinctCount;
    }

    public int getWriteBackId() {
        return this.writeBackId;
    }

    public int getFileBits() {
        return this.fileBits;
    }

    public int getBufferBits() {
        return this.bufferBits;
    }
}

