/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;

public class OlapFactIntMemMapList
extends OlapFactBaseMemMapList<IntBuffer>
implements IOlapFactIntList {
    private OlapFactIntMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactIntList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactIntMemMapList(configuration);
    }

    @Override
    protected String getFriendlyTypeName() {
        return "int";
    }

    @Override
    public int getValueByteCount() {
        return 4;
    }

    protected IntBuffer[] createBuffers(int count) {
        return new IntBuffer[count];
    }

    @Override
    protected IntBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer.asIntBuffer();
    }

    @Override
    public void add(int val) {
        this.ensureCapacity();
        ((IntBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Integer)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactIntMemMapList this$0;
            {
                OlapFactIntMemMapList olapFactIntMemMapList = this$0;
                Objects.requireNonNull(olapFactIntMemMapList);
                this.this$0 = olapFactIntMemMapList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Integer[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Integer.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    @Override
    public void setQuick(int offset, int val) {
        ((IntBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public int getQuick(int rowId) {
        return ((IntBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public int lookup(int lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startBufferIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < ((IntBuffer[])this.buffers).length; ++idx) {
            IntBuffer buffer = ((IntBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = startBufferIdx; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                int value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startBufferIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, int val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        IntBuffer values = ((IntBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            int value = values.get(rowId & this.bufferItemCountMask);
            if (value == Integer.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        int value = this.getQuick(rowId);
        if (value != Integer.MIN_VALUE) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        IntBuffer buffer = ((IntBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            int value = buffer.get(offset);
            if (value == Integer.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        IntBuffer typedBuffer = ((IntBuffer[])this.buffers)[((IntBuffer[])this.buffers).length - 1];
        typedBuffer.rewind();
        typedBuffer.put(buffer.asIntBuffer());
    }
}

