/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;

public class OlapFactFloatMemMapList
extends OlapFactBaseMemMapList<FloatBuffer>
implements IOlapFactFloatList {
    private OlapFactFloatMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactFloatList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactFloatMemMapList(configuration);
    }

    @Override
    protected String getFriendlyTypeName() {
        return "float";
    }

    @Override
    public int getValueByteCount() {
        return 4;
    }

    protected FloatBuffer[] createBuffers(int count) {
        return new FloatBuffer[count];
    }

    @Override
    protected FloatBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer.asFloatBuffer();
    }

    @Override
    public void add(float val) {
        this.ensureCapacity();
        ((FloatBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add(((Float)values.get(ii)).floatValue());
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactFloatMemMapList this$0;
            {
                OlapFactFloatMemMapList olapFactFloatMemMapList = this$0;
                Objects.requireNonNull(olapFactFloatMemMapList);
                this.this$0 = olapFactFloatMemMapList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Float[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Float.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    @Override
    public void setQuick(int offset, float val) {
        ((FloatBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public float getQuick(int rowId) {
        return ((FloatBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public int lookup(float lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startBufferIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < ((FloatBuffer[])this.buffers).length; ++idx) {
            FloatBuffer buffer = ((FloatBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = startBufferIdx; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                float value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startBufferIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, float val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        FloatBuffer values = ((FloatBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            float value = values.get(rowId & this.bufferItemCountMask);
            if (value == Float.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        float value = this.getQuick(rowId);
        if (value != Float.NEGATIVE_INFINITY) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        FloatBuffer buffer = ((FloatBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            float value = buffer.get(offset);
            if (value == Float.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        FloatBuffer typedBuffer = ((FloatBuffer[])this.buffers)[((FloatBuffer[])this.buffers).length - 1];
        typedBuffer.rewind();
        typedBuffer.put(buffer.asFloatBuffer());
    }
}

